/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips.mixin;

import com.anthonyhilyard.iceberg.util.Tooltips;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Screen.class})
public class ScreenMixin {
    @ModifyVariable(method={"renderTooltipInternal"}, ordinal=0, at=@At(value="LOAD", ordinal=0), argsOnly=true)
    private List<ClientTooltipComponent> mutableComponents(List<ClientTooltipComponent> components) {
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.centeredTitle.get()).booleanValue()) {
            return new ArrayList<ClientTooltipComponent>(components);
        }
        return components;
    }

    @ModifyVariable(method={"renderTooltipInternal"}, ordinal=2, at=@At(value="INVOKE", target="Ljava/util/List;size()I", ordinal=0))
    private int setMinimumWidth(int width) {
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.enforceMinimumWidth.get()).booleanValue()) {
            return Math.max(width, 48);
        }
        return width;
    }

    @Inject(method={"renderTooltipInternal"}, at={@At(value="INVOKE", target="Ljava/util/List;size()I", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void centerTitle(PoseStack poseStack, List<ClientTooltipComponent> components, int x, int y, CallbackInfo info, RenderTooltipEvent.Pre preEvent) {
        if (!components.isEmpty() && ((Boolean)LegendaryTooltipsConfig.INSTANCE.centeredTitle.get()).booleanValue()) {
            int tooltipWidth = 0;
            if (((Boolean)LegendaryTooltipsConfig.INSTANCE.enforceMinimumWidth.get()).booleanValue()) {
                tooltipWidth = 48;
            }
            tooltipWidth = new Tooltips.TooltipInfo(components, preEvent.getFont(), 1).getMaxLineWidth(tooltipWidth);
            List centeredComponents = Tooltips.centerTitle(components, (Font)preEvent.getFont(), (int)tooltipWidth, (int)Tooltips.calculateTitleLines(components));
            components.clear();
            components.addAll(centeredComponents);
        }
    }
}

