/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.mixin.features.activation_range;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import java.util.function.BooleanSupplier;
import me.wesley1808.servercore.common.activation_range.ActivationRange;
import me.wesley1808.servercore.common.config.tables.ActivationRangeConfig;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public class ServerLevelMixin {
    @Shadow
    @Final
    private MinecraftServer f_8548_;

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/EntityTickList;forEach(Ljava/util/function/Consumer;)V")})
    private void servercore$activateEntities(BooleanSupplier booleanSupplier, CallbackInfo ci) {
        if (ActivationRangeConfig.ENABLED.get().booleanValue() && this.f_8548_.m_129921_() % 20 == 0) {
            ActivationRange.activateEntities((ServerLevel)this);
        }
    }

    @WrapWithCondition(method={"tickNonPassenger"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;tick()V")})
    private boolean servercore$shouldTickEntity(Entity entity) {
        if (ActivationRange.checkIfActive(entity, this.f_8548_.m_129921_())) {
            entity.setInactive(false);
            ++entity.f_19797_;
            return true;
        }
        entity.setInactive(true);
        entity.inactiveTick();
        return false;
    }

    @WrapWithCondition(method={"tickPassenger"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;rideTick()V")})
    private boolean servercore$shouldTickPassenger(Entity passenger, Entity vehicle, Entity ignored) {
        if (ActivationRange.checkIfActive(passenger, this.f_8548_.m_129921_())) {
            passenger.setInactive(false);
            ++passenger.f_19797_;
            return true;
        }
        passenger.m_20256_(Vec3.f_82478_);
        passenger.setInactive(true);
        passenger.inactiveTick();
        vehicle.m_7332_(passenger);
        return false;
    }

    @Redirect(method={"tickNonPassenger", "tickPassenger"}, at=@At(value="FIELD", target="net/minecraft/world/entity/Entity.tickCount:I", opcode=181))
    private void servercore$redirectTickCount(Entity entity, int value) {
        entity.incFullTickCount();
    }
}

