/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.utils;

import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import me.wesley1808.servercore.common.config.tables.EntityLimitConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public enum BreedingCap {
    ANIMAL(EntityLimitConfig.ANIMAL_COUNT::get, EntityLimitConfig.ANIMAL_RANGE::get),
    VILLAGER(EntityLimitConfig.VILLAGER_COUNT::get, EntityLimitConfig.VILLAGER_RANGE::get);

    private static final Map<EntityType<?>, Set<EntityType<?>>> CUSTOM_TYPES;
    private final IntSupplier limit;
    private final IntSupplier range;

    private BreedingCap(IntSupplier limit, IntSupplier range) {
        this.limit = limit;
        this.range = range;
    }

    public static void resetLove(Animal owner, Animal mate) {
        BreedingCap.resetAge((AgeableMob)owner, (AgeableMob)mate);
        owner.m_27594_();
        mate.m_27594_();
    }

    public static void resetAge(AgeableMob owner, AgeableMob mate) {
        owner.m_146762_(6000);
        mate.m_146762_(6000);
    }

    public boolean exceedsLimit(EntityType<?> type, Level level, BlockPos pos) {
        if (!EntityLimitConfig.ENABLED.get().booleanValue()) {
            return false;
        }
        AABB area = this.getAreaAt(pos);
        Set<EntityType<?>> set = CUSTOM_TYPES.get(type);
        int count = set != null && !set.isEmpty() ? level.m_6249_((Entity)null, area, entity -> set.contains(entity.m_6095_())).size() : level.m_142425_(type, area, EntitySelector.f_20408_).size();
        return this.limit.getAsInt() <= count;
    }

    public boolean exceedsLimit(Entity entity) {
        return this.exceedsLimit(entity.m_6095_(), entity.m_9236_(), entity.m_20183_());
    }

    private AABB getAreaAt(BlockPos pos) {
        int range = this.range.getAsInt();
        return new AABB(pos.m_7918_(range, range, range), pos.m_7918_(-range, -range, -range));
    }

    static {
        CUSTOM_TYPES = Map.of(EntityType.f_217012_, Set.of(EntityType.f_217013_, EntityType.f_217012_));
    }
}

