/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.wesley1808.servercore.common.config.tables.CommandConfig;
import me.wesley1808.servercore.common.dynamic.DynamicManager;
import me.wesley1808.servercore.common.services.Formatter;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.NaturalSpawner;

public class MobcapsCommand {
    private static final LocalMobCapCalculator.MobCounts EMPTY_MOBCOUNTS = new LocalMobCapCalculator.MobCounts();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (CommandConfig.COMMAND_MOBCAPS.get().booleanValue()) {
            dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"mobcaps").executes(ctx -> MobcapsCommand.mobcaps(((CommandSourceStack)ctx.getSource()).m_81375_())));
        }
    }

    private static int mobcaps(ServerPlayer player) {
        StringBuilder builder = new StringBuilder(Formatter.line(CommandConfig.MOBCAP_TITLE.get().replace("${mobcap_percentage}", DynamicManager.getModifierAsPercentage()), 50, true));
        NaturalSpawner.SpawnState state = player.m_9236_().m_7726_().m_8485_();
        if (state != null) {
            LocalMobCapCalculator.MobCounts mobCounts = state.f_186542_.f_186498_.getOrDefault(player, EMPTY_MOBCOUNTS);
            for (MobCategory category : MobCategory.values()) {
                builder.append("\n").append(CommandConfig.MOBCAP_CONTENT.get().replace("${name}", category.m_21607_()).replace("${current}", String.valueOf(mobCounts.f_186515_.getOrDefault((Object)category, 0))).replace("${capacity}", String.valueOf(category.m_21608_())));
            }
        }
        player.m_213846_(Formatter.parse(builder.toString()));
        return 1;
    }
}

