/*
 * Decompiled with CFR 0.152.
 */
package com.lootintegrations.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lootintegrations.LootintegrationsMod;
import com.lootintegrations.config.CommonConfiguration;
import com.lootintegrations.loot.INoMapContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.server.ServerLifecycleHooks;

public class GlobalLootModifierIntegration {
    private final ResourceLocation location;
    public ResourceLocation lootTableId;
    public Map<ResourceLocation, Integer> integratedTables = new HashMap<ResourceLocation, Integer>();
    private int fillSize = 27;
    private static final Set<ResourceLocation> inbuiltTables = Set.of(LootintegrationsMod.resFor("chests/easy"), LootintegrationsMod.resFor("chests/medium"), LootintegrationsMod.resFor("chests/hard"), LootintegrationsMod.resFor("chests/nether"), LootintegrationsMod.resFor("chests/water"), LootintegrationsMod.resFor("chests/village"), LootintegrationsMod.resFor("chests/empty"));
    private static final String LOOT_TABLE_ID = "loot_table";
    private static final String INTEGRATED_LOOT_TABLES = "integrated_loot_tables";
    private static final String MAX_RESULT_ITEMCOUNT = "max_result_itemcount";

    private GlobalLootModifierIntegration(ResourceLocation location) {
        this.location = location;
    }

    @Nonnull
    public void doApply(List<ItemStack> generatedLoot, LootContext context) {
        int weight;
        int i;
        Object extraItems;
        try {
            if (context instanceof INoMapContext) {
                INoMapContext noMapContext = (INoMapContext)context;
                if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).skipMapItems) {
                    noMapContext.disabledMaps();
                }
            }
            extraItems = ServerLifecycleHooks.getCurrentServer().m_129898_().m_79217_(this.lootTableId).m_230922_(context);
        }
        catch (Exception e) {
            LootintegrationsMod.LOGGER.debug("Loot generation of modifier:" + this.location + " for context failed for:" + this.lootTableId, (Throwable)e);
            return;
        }
        if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput && !inbuiltTables.contains(this.lootTableId)) {
            LootintegrationsMod.LOGGER.info("Adding loot to: " + context.getQueriedLootTableId() + "from: " + this.lootTableId + " caused by:" + this.location);
        }
        if (extraItems.isEmpty()) {
            return;
        }
        int itemCount = this.integratedTables.getOrDefault(context.getQueriedLootTableId(), 1);
        if ((extraItems = this.aggregateStacks((List<ItemStack>)extraItems, false)).isEmpty()) {
            return;
        }
        if (!generatedLoot.isEmpty() && generatedLoot.size() + itemCount > this.fillSize) {
            List<ItemStack> newList = this.aggregateStacks(generatedLoot, true);
            generatedLoot.clear();
            generatedLoot.addAll(newList);
            if (generatedLoot.size() > this.fillSize) {
                int size = Math.min(generatedLoot.size(), generatedLoot.size() + itemCount - this.fillSize);
                for (int i2 = 0; i2 < size; ++i2) {
                    generatedLoot.remove(LootintegrationsMod.rand.nextInt(generatedLoot.size()));
                }
            }
        }
        if (itemCount == 0) {
            return;
        }
        int[] weights = new int[extraItems.size()];
        int totalWeight = 0;
        int size = extraItems.size();
        for (i = 0; i < size; ++i) {
            weight = this.calcWeightForStack((ItemStack)extraItems.get(i));
            weights[i] = totalWeight += weight;
        }
        for (i = 0; i < itemCount; ++i) {
            if (totalWeight <= 0) {
                return;
            }
            weight = LootintegrationsMod.rand.nextInt(totalWeight);
            int index = -1;
            int removedWeight = 0;
            ItemStack stack = null;
            for (int j = 0; j < size; ++j) {
                if (index == -1 && weight < weights[j]) {
                    index = j;
                    weights[j] = 0;
                    stack = (ItemStack)extraItems.get(index);
                    removedWeight = this.calcWeightForStack(stack);
                    totalWeight -= removedWeight;
                    continue;
                }
                if (index == -1) continue;
                int n = j;
                weights[n] = weights[n] - removedWeight;
            }
            if (stack == null) continue;
            boolean sameItem = false;
            if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).skipExistingItems) {
                for (int j = 0; j < generatedLoot.size(); ++j) {
                    if (!ItemStack.m_150942_((ItemStack)generatedLoot.get(j), (ItemStack)stack)) continue;
                    sameItem = true;
                    break;
                }
            }
            if (!sameItem) {
                generatedLoot.add(stack);
                if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
                    LootintegrationsMod.LOGGER.info("Adding loot to: " + context.getQueriedLootTableId() + " item:" + stack.toString());
                }
            }
            if (extraItems.isEmpty()) break;
        }
    }

    private int calcWeightForStack(ItemStack stack) {
        return ((ResourceKey)stack.m_220173_().m_203543_().get()).m_135782_().m_135827_().equals("minecraft") ? 1 : ((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).moddedItemWeight + 1;
    }

    private List<ItemStack> aggregateStacks(List<ItemStack> stacksIn, boolean originalLoot) {
        HashMap<Item, ItemStack> aggregated = new HashMap<Item, ItemStack>();
        for (ItemStack stack : stacksIn) {
            ItemStack contained = (ItemStack)aggregated.get(stack.m_41720_());
            if (stack.m_41619_()) continue;
            if (contained == null) {
                aggregated.put(stack.m_41720_(), stack);
                continue;
            }
            if (!GlobalLootModifierIntegration.compareItemStacksIgnoreStackSize(stack, contained, false, true)) continue;
            contained.m_41764_(Math.min(contained.m_41613_() + stack.m_41613_(), Math.max(1, contained.m_41741_() / 2)));
        }
        return new ArrayList<ItemStack>(aggregated.values());
    }

    public static GlobalLootModifierIntegration read(ResourceLocation location, JsonElement data) {
        GlobalLootModifierIntegration modifier = new GlobalLootModifierIntegration(location);
        JsonObject jsonData = (JsonObject)data;
        modifier.lootTableId = new ResourceLocation(jsonData.get(LOOT_TABLE_ID).getAsString());
        if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput && !location.m_135815_().contains("lootintegrations_")) {
            LootintegrationsMod.LOGGER.info("Parsing loot modifiers for:" + location + " with loottable: " + modifier.lootTableId);
        }
        if (jsonData.has(MAX_RESULT_ITEMCOUNT)) {
            modifier.fillSize = jsonData.get(MAX_RESULT_ITEMCOUNT).getAsInt();
        }
        HashMap<ResourceLocation, Integer> integratedTables = new HashMap<ResourceLocation, Integer>();
        for (Map.Entry element : jsonData.get(INTEGRATED_LOOT_TABLES).getAsJsonObject().entrySet()) {
            ResourceLocation integratedTable = new ResourceLocation((String)element.getKey());
            integratedTables.put(integratedTable, ((JsonElement)element.getValue()).getAsInt());
        }
        modifier.integratedTables = integratedTables;
        return modifier;
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT) {
        if (itemStack1.m_41619_() && itemStack2.m_41619_()) {
            return true;
        }
        if (itemStack1.m_41619_() && !itemStack2.m_41619_() || !itemStack1.m_41619_() && itemStack2.m_41619_()) {
            return false;
        }
        if (itemStack1 == itemStack2) {
            return true;
        }
        if (!matchDamage || itemStack1.m_41773_() == itemStack2.m_41773_()) {
            if (!matchNBT) {
                return true;
            }
            if (itemStack1.m_41782_() && itemStack2.m_41782_()) {
                CompoundTag nbt1 = itemStack1.m_41783_();
                CompoundTag nbt2 = itemStack2.m_41783_();
                for (String key : nbt1.m_128431_()) {
                    if (!matchDamage && key.equals("Damage") || nbt2.m_128441_(key) && nbt1.m_128423_(key).equals(nbt2.m_128423_(key))) continue;
                    return false;
                }
                return nbt1.m_128431_().size() == nbt2.m_128431_().size();
            }
            return !(itemStack1.m_41782_() && !itemStack1.m_41783_().m_128456_() || itemStack2.m_41782_() && !itemStack2.m_41783_().m_128456_());
        }
        return false;
    }
}

