/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucianowayand.eyesoficeandfire;

import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class EnderEyes
extends Item {
    DragonType type;

    public EnderEyes(Item.Properties properties, DragonType type) {
        super(properties);
        this.type = type;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        EntityDragonBase dragonFound = this.getClosestDragon(levelIn, playerIn, this.type);
        if (dragonFound == null) {
            playerIn.m_5661_((Component)Component.m_237115_((String)"chat.no_dragons_found"), true);
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        playerIn.m_6672_(handIn);
        if (levelIn instanceof ServerLevel) {
            BlockPos blockpos = new BlockPos(dragonFound.getHeadPosition().f_82479_, dragonFound.getHeadPosition().f_82480_, dragonFound.getHeadPosition().f_82481_);
            EyeOfEnder eye_of_ender_entity = new EyeOfEnder(levelIn, playerIn.m_20185_(), playerIn.m_20227_(0.5), playerIn.m_20189_());
            eye_of_ender_entity.m_36972_(itemstack);
            eye_of_ender_entity.m_36967_(blockpos);
            levelIn.m_7967_((Entity)eye_of_ender_entity);
            if (playerIn instanceof ServerPlayer) {
                CriteriaTriggers.f_10579_.m_73935_((ServerPlayer)playerIn, blockpos);
            }
            levelIn.m_5594_(null, playerIn.m_20183_(), SoundEvents.f_11898_, SoundSource.NEUTRAL, 0.5f, 0.4f / (levelIn.m_213780_().m_188501_() * 0.4f + 0.8f));
            levelIn.m_5898_(null, 1003, playerIn.m_20183_(), 0);
            if (!playerIn.m_7500_()) {
                itemstack.m_41774_(1);
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            playerIn.m_21011_(handIn, true);
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    private EntityDragonBase getClosestDragon(Level world, Player player, DragonType type) {
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        AABB box = new AABB(x - 576.0, -64.0, z - 576.0, x + 576.0, y + 320.0, z + 576.0);
        List listOfTargets = world.m_45976_(EntityDragonBase.class, box);
        float min = 0.0f;
        EntityDragonBase closest = null;
        for (EntityDragonBase target : listOfTargets) {
            if (target.isModelDead() || target.m_21824_() || target.dragonType != type) continue;
            float distance = target.m_20270_((Entity)player);
            if (min != 0.0f && !(distance < min)) continue;
            min = distance;
            closest = target;
        }
        return closest;
    }
}

