/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.tab;

import com.github.manasmods.manascore.api.tab.AbstractInventoryTab;
import com.github.manasmods.manascore.api.tab.annotation.ScreenForTab;
import com.github.manasmods.manascore.client.gui.widget.InventoryTabSwitcherWidget;
import com.github.manasmods.manascore.tab.InventoryTabRegistry;
import java.util.Map;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber(modid="manascore", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
@ApiStatus.Internal
public class InventoryTabHandler {
    @SubscribeEvent
    public static void onOpenTabMenu(ScreenEvent.Init e) {
        if (!InventoryTabHandler.isValidTabScreen(e.getScreen())) {
            return;
        }
        Screen screen = e.getScreen();
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
        Map<Integer, AbstractInventoryTab> tabRegistryEntries = InventoryTabRegistry.getEntries();
        InventoryTabSwitcherWidget tabSwitcherWidget = new InventoryTabSwitcherWidget(containerScreen, (int)Math.round(Math.ceil((float)tabRegistryEntries.size() / 12.0f)));
        tabRegistryEntries.forEach(tabSwitcherWidget::addUpdateListener);
        tabSwitcherWidget.updateTabs();
        e.addListener((GuiEventListener)tabSwitcherWidget);
    }

    private static boolean isValidTabScreen(Screen screen) {
        if (screen instanceof InventoryScreen) {
            return true;
        }
        return screen.getClass().isAnnotationPresent(ScreenForTab.class);
    }
}

