/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.network.toserver;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.SweepingEdgeEnchantment;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class RequestSweepChancePacket {
    public RequestSweepChancePacket(FriendlyByteBuf buf) {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                this.sweepAttack((Player)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void sweepAttack(Player player) {
        double radiusAddition = (player.getAttackRange() - 1.0) / 2.0;
        float sweepAttack = 1.0f + this.getSweepingDamageRatio((LivingEntity)player) * this.getAttackDamage(player);
        AABB sweepArea = player.m_20191_().m_82377_(1.0 + radiusAddition, 0.25, 1.0 + radiusAddition).m_82383_(this.getLookTowardVec(player, 1.0 + radiusAddition));
        List list = player.f_19853_.m_45976_(LivingEntity.class, sweepArea);
        if (list.isEmpty()) {
            return;
        }
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
        player.m_36346_();
        for (LivingEntity target : list) {
            ArmorStand armorStand;
            if (target == player || target.m_7307_((Entity)player) || target instanceof ArmorStand && (armorStand = (ArmorStand)target).m_31677_() || !player.canHit((Entity)target, 0.0)) continue;
            target.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
            target.m_6469_(DamageSource.m_19344_((Player)player), sweepAttack);
        }
    }

    private float getSweepingDamageRatio(LivingEntity pEntity) {
        int i = 1 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)pEntity);
        return i > 0 ? SweepingEdgeEnchantment.m_45193_((int)i) : 0.0f;
    }

    private float getAttackDamage(Player player) {
        float f = (float)player.m_21133_(Attributes.f_22281_);
        float h = player.m_36403_(0.5f);
        return f *= 0.2f + h * h * 0.8f;
    }

    private Vec3 getLookTowardVec(Player player, double distance) {
        float f = player.m_146909_();
        float g = player.m_146908_();
        float h = Mth.m_14089_((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = Mth.m_14031_((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float k = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        return new Vec3((double)(i * j) * distance, (double)k * distance, (double)(h * j) * distance);
    }

    public RequestSweepChancePacket() {
    }
}

