/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.network.toserver;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.SkillToggleEvent;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;

public class RequestSkillTogglePacket {
    private final ResourceLocation skill;

    public RequestSkillTogglePacket(FriendlyByteBuf buf) {
        this.skill = buf.m_130281_();
    }

    public RequestSkillTogglePacket(ResourceLocation skill) {
        this.skill = skill;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.skill);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ManasSkillInstance instance;
                SkillToggleEvent event;
                Optional<ManasSkillInstance> optional;
                SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
                ManasSkill manasSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(this.skill);
                if (manasSkill != null && (optional = storage.getSkill(manasSkill)).isPresent() && !MinecraftForge.EVENT_BUS.post((Event)(event = new SkillToggleEvent(instance, (Player)player, !(instance = optional.get()).isToggled())))) {
                    if (instance.canInteractSkill((LivingEntity)player) && instance.canBeToggled((LivingEntity)player)) {
                        instance.setToggled(!instance.isToggled());
                        if (instance.isToggled()) {
                            instance.onToggleOn((LivingEntity)player);
                        } else {
                            instance.onToggleOff((LivingEntity)player);
                        }
                    }
                    storage.syncChanges();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

