/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.network.toserver;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class RequestSkillScrollPacket {
    private final double delta;
    private final List<ResourceLocation> skillList;

    public RequestSkillScrollPacket(FriendlyByteBuf buf) {
        this.skillList = buf.m_236845_(FriendlyByteBuf::m_130281_);
        this.delta = buf.readDouble();
    }

    public RequestSkillScrollPacket(List<ResourceLocation> skills, double delta) {
        this.skillList = RequestSkillScrollPacket.validateList(skills);
        this.delta = delta;
    }

    private static List<ResourceLocation> validateList(List<ResourceLocation> list) {
        if (list.size() > 100) {
            throw new IllegalArgumentException("Skill list exceeds maximum size of 100.");
        }
        return list;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_236828_(this.skillList, FriendlyByteBuf::m_130085_);
        buf.writeDouble(this.delta);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
                for (ResourceLocation id : this.skillList) {
                    Optional<ManasSkillInstance> optional;
                    ManasSkill manasSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(id);
                    if (manasSkill == null || (optional = storage.getSkill(manasSkill)).isEmpty() || !optional.get().canInteractSkill((LivingEntity)player)) continue;
                    optional.get().onScroll((LivingEntity)player, this.delta);
                }
                storage.syncChanges();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

