/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.network.toserver;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.TickingSkill;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.SkillReleaseEvent;
import com.github.manasmods.manascore.capability.skill.event.TickEventListenerHandler;
import com.google.common.collect.Multimap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;

public class RequestSkillReleasePacket {
    private final int heldTick;
    private final int keyNumber;
    private final ResourceLocation skill;

    public RequestSkillReleasePacket(FriendlyByteBuf buf) {
        this.skill = buf.m_130281_();
        this.keyNumber = buf.readInt();
        this.heldTick = buf.readInt();
    }

    public RequestSkillReleasePacket(ResourceLocation skill, int keyNumber, int ticks) {
        this.skill = skill;
        this.keyNumber = keyNumber;
        this.heldTick = ticks;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.skill);
        buf.writeInt(this.keyNumber);
        buf.writeInt(this.heldTick);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ManasSkillInstance skillInstance;
                SkillReleaseEvent event;
                Optional<ManasSkillInstance> optional;
                SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
                ManasSkill manasSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(this.skill);
                if (manasSkill != null && (optional = storage.getSkill(manasSkill)).isPresent() && !MinecraftForge.EVENT_BUS.post((Event)(event = new SkillReleaseEvent(skillInstance = optional.get(), (Player)player, this.keyNumber, this.heldTick)))) {
                    if (skillInstance.canInteractSkill((LivingEntity)player) && (!skillInstance.onCoolDown() || skillInstance.canIgnoreCoolDown((LivingEntity)player))) {
                        skillInstance.onRelease((LivingEntity)player, this.heldTick);
                    }
                    skillInstance.removeHeldAttributeModifiers((LivingEntity)player);
                    Multimap<UUID, TickingSkill> multimap = TickEventListenerHandler.tickingSkills;
                    if (multimap.containsKey((Object)player.m_20148_())) {
                        multimap.get((Object)player.m_20148_()).removeIf(tickingSkill -> tickingSkill.getSkill() == skillInstance.getSkill());
                    }
                    storage.syncChanges();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

