/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.network.toserver;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.TickingSkill;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.SkillActivationEvent;
import com.github.manasmods.manascore.capability.skill.event.TickEventListenerHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;

public class RequestSkillActivationPacket {
    private final int keyNumber;
    private final ResourceLocation skill;

    public RequestSkillActivationPacket(FriendlyByteBuf buf) {
        this.skill = buf.m_130281_();
        this.keyNumber = buf.readInt();
    }

    public RequestSkillActivationPacket(ResourceLocation skill, int keyNumber) {
        this.skill = skill;
        this.keyNumber = keyNumber;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.skill);
        buf.writeInt(this.keyNumber);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ManasSkillInstance instance;
                SkillActivationEvent event;
                Optional<ManasSkillInstance> optional;
                SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
                ManasSkill manasSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(this.skill);
                if (manasSkill != null && (optional = storage.getSkill(manasSkill)).isPresent() && !MinecraftForge.EVENT_BUS.post((Event)(event = new SkillActivationEvent(instance = optional.get(), (Player)player, this.keyNumber))) && instance.canInteractSkill((LivingEntity)player) && (!instance.onCoolDown() || instance.canIgnoreCoolDown((LivingEntity)player))) {
                    instance.onPressed((LivingEntity)player);
                    instance.addHeldAttributeModifiers((LivingEntity)player);
                    TickEventListenerHandler.tickingSkills.put((Object)player.m_20148_(), (Object)new TickingSkill(instance.getSkill()));
                    storage.syncChanges();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

