/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.network.toclient;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.capability.skill.InternalSkillStorage;
import com.github.manasmods.manascore.network.toclient.ClientLevelAccessor;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkEvent;

public class SyncSkillsPacket {
    private final int entityId;
    private final SyncType syncType;
    private final CompoundTag skills;

    public SyncSkillsPacket(Entity source, InternalSkillStorage internalSkillStorage, SyncType syncType) {
        this.entityId = source.m_19879_();
        this.syncType = syncType;
        this.skills = syncType.factory.create(internalSkillStorage);
    }

    public SyncSkillsPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.syncType = (SyncType)buf.m_130066_(SyncType.class);
        this.skills = buf.m_130261_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130068_((Enum)this.syncType);
        buf.m_130079_(this.skills);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.syncType.handler.update(this.entityId, this.skills));
        ctx.get().setPacketHandled(true);
    }

    public static enum SyncType {
        FULL(INBTSerializable::serializeNBT, (entityId1, updateTag) -> ClientLevelAccessor.execute(level -> {
            Entity target = level.m_6815_(entityId1);
            if (target == null) {
                return;
            }
            SkillAPI.getSkillsFrom(target).deserializeNBT((Tag)updateTag);
        })),
        CHANGES_ONLY(skillStorage -> {
            CompoundTag tag = new CompoundTag();
            ListTag skills = new ListTag();
            skillStorage.getDirtySkills().forEach(skillInstance -> {
                skillInstance.resetDirty();
                skills.add((Object)skillInstance.toNBT());
            });
            tag.m_128365_("skills", (Tag)skills);
            return tag;
        }, (entityId1, updateTag) -> ClientLevelAccessor.execute(level -> {
            Entity target = level.m_6815_(entityId1);
            if (target == null) {
                return;
            }
            if (!updateTag.m_128441_("skills")) {
                return;
            }
            ArrayList<ManasSkillInstance> updatedSkills = new ArrayList<ManasSkillInstance>();
            for (Tag tag : updateTag.m_128437_("skills", 10)) {
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag compoundTag = (CompoundTag)tag;
                updatedSkills.add(ManasSkillInstance.fromNBT(compoundTag));
            }
            SkillAPI.getSkillsFrom(target).updateSkills(updatedSkills);
        }));

        private final UpdateFactory factory;
        private final UpdateHandler handler;

        private SyncType(UpdateFactory factory, UpdateHandler handler) {
            this.factory = factory;
            this.handler = handler;
        }
    }

    @FunctionalInterface
    private static interface UpdateFactory {
        public CompoundTag create(InternalSkillStorage var1);
    }

    @FunctionalInterface
    private static interface UpdateHandler {
        public void update(int var1, CompoundTag var2);
    }
}

