/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.client.keybinding;

import com.github.manasmods.manascore.api.client.keybinding.KeybindingCategory;
import com.github.manasmods.manascore.api.client.keybinding.ManasKeybinding;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber(modid="manascore", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
@ApiStatus.Internal
public class KeybindingRegistry {
    private static final Logger log = LogManager.getLogger(KeybindingRegistry.class);
    private static final ArrayList<ManasKeybinding> keybindings = new ArrayList();

    @SubscribeEvent
    public static void register(RegisterKeyMappingsEvent e) {
        keybindings.forEach(arg_0 -> ((RegisterKeyMappingsEvent)e).register(arg_0));
    }

    public static void register(ManasKeybinding ... keybinding) {
        keybindings.addAll(Arrays.asList(keybinding));
    }

    public static void checkKeybindings(InputEvent.Key e) {
        keybindings.forEach(keybinding -> {
            if (keybinding.m_90857_()) {
                keybinding.getAction().onPress();
            } else if (keybinding.getRelease() != null) {
                keybinding.getRelease().run();
            }
        });
    }

    static {
        if (!FMLEnvironment.production) {
            KeybindingCategory category = KeybindingCategory.of("test");
            keybindings.add(new ManasKeybinding("manascore.keybinding.test", category, () -> log.info("Pressing"), duration -> log.info("Released in {} Seconds", (Object)((double)duration / 1000.0))));
            keybindings.add(new ManasKeybinding("manascore.keybinding.test_press", category, () -> log.info("Pressed")));
            keybindings.add(new ManasKeybinding("manascore.keybinding.skill", category, () -> SkillAPI.skillActivationPacket(new ResourceLocation("manascore", "example_test_skill"), 0), duration -> SkillAPI.skillReleasePacket(new ResourceLocation("manascore", "example_test_skill"), 0, (int)(duration / 50L))));
            keybindings.add(new ManasKeybinding("manascore.keybinding.skill_toggle", category, () -> SkillAPI.skillTogglePacket(new ResourceLocation("manascore", "example_test_skill"))));
        }
    }
}

