/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.client.gui.widget;

import com.github.manasmods.manascore.api.tab.AbstractInventoryTab;
import com.github.manasmods.manascore.core.AbstractContainerScreenAccessor;
import com.github.manasmods.manascore.tab.TabPosition;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class InventoryTabSwitcherWidget
extends GuiComponent
implements Widget,
GuiEventListener {
    private int page = 1;
    private final int maxPages;
    private final Button prevButton;
    private final Button nextButton;
    private final TreeMap<Integer, AbstractInventoryTab> tabs = new TreeMap();
    private final AbstractContainerScreen parent;

    public InventoryTabSwitcherWidget(AbstractContainerScreen parent, int maxPages) {
        this.parent = parent;
        this.maxPages = maxPages;
        this.prevButton = new Button(this.parent.getGuiLeft() - 20 - 2, this.parent.getGuiTop() - 20 - 2, 20, 20, (Component)Component.m_237113_((String)"<"), b -> {
            this.page = Math.max(this.page - 1, 1);
            this.updateTabs();
        });
        this.nextButton = new Button(parent.getGuiLeft() + ((AbstractContainerScreenAccessor)parent).getImageWidth() + 2, this.parent.getGuiTop() - 20 - 2, 20, 20, (Component)Component.m_237113_((String)">"), b -> {
            this.page = Math.min(this.page + 1, this.maxPages);
            this.updateTabs();
        });
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.page > 1) {
            this.prevButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
        if (this.maxPages > 1 && this.page != this.maxPages) {
            this.nextButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
        if (this.maxPages > 1) {
            InventoryTabSwitcherWidget.m_93208_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (String)(this.page + " / " + this.maxPages), (int)(this.parent.f_96543_ / 2), (int)2, (int)Color.WHITE.getRGB());
        }
        this.tabs.values().stream().filter(AbstractWidget::m_142518_).forEach(abstractInventoryTab -> abstractInventoryTab.m_6305_(poseStack, mouseX, mouseY, partialTicks));
    }

    public void updateTabs() {
        this.tabs.forEach((integer, widget) -> {
            boolean isVisible;
            int tabScreenIndex;
            for (tabScreenIndex = integer.intValue(); tabScreenIndex > 12; tabScreenIndex -= 12) {
            }
            int yOffset = 4;
            boolean xOffset = true;
            switch (tabScreenIndex) {
                case 1: {
                    widget.f_93620_ = this.parent.getGuiLeft();
                    widget.f_93621_ = this.parent.getGuiTop() - widget.m_93694_() + 4;
                    widget.setPosition(TabPosition.LEFT_TOP);
                    break;
                }
                case 2: 
                case 3: {
                    widget.f_93620_ = this.parent.getGuiLeft() + widget.m_5711_() * (tabScreenIndex - 1) + (1 * tabScreenIndex - 1) + 1;
                    widget.f_93621_ = this.parent.getGuiTop() - widget.m_93694_() + 4;
                    widget.setPosition(TabPosition.TOP);
                    break;
                }
                case 4: 
                case 5: {
                    widget.f_93620_ = this.parent.getGuiLeft() + widget.m_5711_() * (tabScreenIndex - 1) + (1 * tabScreenIndex - 1) + 2;
                    widget.f_93621_ = this.parent.getGuiTop() - widget.m_93694_() + 4;
                    widget.setPosition(TabPosition.TOP);
                    break;
                }
                case 6: {
                    widget.f_93620_ = this.parent.getGuiLeft() + widget.m_5711_() * (tabScreenIndex - 1) + (1 * tabScreenIndex - 1) + 3;
                    widget.f_93621_ = this.parent.getGuiTop() - widget.m_93694_() + 4;
                    widget.setPosition(TabPosition.RIGHT_TOP);
                    break;
                }
                case 7: {
                    widget.f_93620_ = this.parent.getGuiLeft();
                    widget.f_93621_ = this.parent.getGuiTop() + ((AbstractContainerScreenAccessor)this.parent).getImageWidth() - 4 - 11;
                    widget.setPosition(TabPosition.LEFT_BOT);
                    break;
                }
                case 8: 
                case 9: {
                    widget.f_93620_ = this.parent.getGuiLeft() + widget.m_5711_() * (tabScreenIndex - 7) + (1 * tabScreenIndex - 7) + 1;
                    widget.f_93621_ = this.parent.getGuiTop() + ((AbstractContainerScreenAccessor)this.parent).getImageWidth() - 4 - 11;
                    widget.setPosition(TabPosition.BOT);
                    break;
                }
                case 10: 
                case 11: {
                    widget.f_93620_ = this.parent.getGuiLeft() + widget.m_5711_() * (tabScreenIndex - 7) + (1 * tabScreenIndex - 7) + 2;
                    widget.f_93621_ = this.parent.getGuiTop() + ((AbstractContainerScreenAccessor)this.parent).getImageWidth() - 4 - 11;
                    widget.setPosition(TabPosition.BOT);
                    break;
                }
                case 12: {
                    widget.f_93620_ = this.parent.getGuiLeft() + widget.m_5711_() * (tabScreenIndex - 7) + (1 * tabScreenIndex - 7) + 3;
                    widget.f_93621_ = this.parent.getGuiTop() + ((AbstractContainerScreenAccessor)this.parent).getImageWidth() - 4 - 11;
                    widget.setPosition(TabPosition.RIGHT_BOT);
                }
            }
            widget.f_93623_ = isVisible = Math.ceil((float)integer.intValue() / 12.0f) == (double)this.page;
        });
    }

    public void addUpdateListener(int index, AbstractInventoryTab widget) {
        this.tabs.put(index, widget);
        this.updateTabs();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.tabs.values().stream().filter(AbstractWidget::m_142518_).forEach(abstractInventoryTab -> abstractInventoryTab.m_6375_(pMouseX, pMouseY, pButton));
            if (this.prevButton.m_5953_(pMouseX, pMouseY)) {
                this.prevButton.m_6375_(pMouseX, pMouseY, pButton);
            }
            if (this.nextButton.m_5953_(pMouseX, pMouseY)) {
                this.nextButton.m_6375_(pMouseX, pMouseY, pButton);
            }
        }
        return false;
    }
}

