/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.capability.skill.event;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.TickingSkill;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.SkillCooldownUpdateEvent;
import com.github.manasmods.manascore.api.skills.event.SkillTickEvent;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="manascore", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TickEventListenerHandler {
    public static final int INSTANCE_UPDATE = 20;
    public static final int PASSIVE_SKILL = 100;
    public static Multimap<UUID, TickingSkill> tickingSkills = ArrayListMultimap.create();

    @SubscribeEvent
    public static void skillHeldTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (!event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (!tickingSkills.containsKey((Object)player.m_20148_())) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        tickingSkills.get((Object)player.m_20148_()).removeIf(tickingSkill -> !tickingSkill.tick(storage, (LivingEntity)player));
        storage.syncChanges();
    }

    @SubscribeEvent
    public static void onSkillTick(LivingEvent.LivingTickEvent event) {
        boolean passiveSkillActivate;
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (level.m_7654_() == null) {
            return;
        }
        boolean shouldPassiveConsume = level.m_7654_().m_129921_() % 20 == 0;
        boolean bl = passiveSkillActivate = level.m_7654_().m_129921_() % 100 == 0;
        if (!shouldPassiveConsume) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            TickEventListenerHandler.updateSkillInstance(serverPlayer);
            TickEventListenerHandler.updateTemporarySkill(serverPlayer);
        }
        if (!passiveSkillActivate) {
            return;
        }
        SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)entity);
        for (ManasSkillInstance instance : List.copyOf(skillStorage.getLearnedSkills())) {
            ManasSkillInstance skillInstance;
            Optional<ManasSkillInstance> optional = skillStorage.getSkill(instance.getSkill());
            if (optional.isEmpty() || !(skillInstance = optional.get()).canInteractSkill(entity) || !skillInstance.getSkill().canTick(skillInstance, entity) || MinecraftForge.EVENT_BUS.post((Event)new SkillTickEvent(skillInstance, entity))) continue;
            skillInstance.onTick(entity);
        }
    }

    private static void updateSkillInstance(ServerPlayer serverPlayer) {
        SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)serverPlayer);
        for (ManasSkillInstance instance : skillStorage.getLearnedSkills()) {
            if (!instance.onCoolDown() || MinecraftForge.EVENT_BUS.post((Event)new SkillCooldownUpdateEvent(instance, (LivingEntity)serverPlayer, instance.getCoolDown()))) continue;
            instance.decreaseCoolDown(1);
        }
        skillStorage.syncChanges();
    }

    private static void updateTemporarySkill(ServerPlayer serverPlayer) {
        SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)serverPlayer);
        for (ManasSkillInstance instance : skillStorage.getLearnedSkills()) {
            if (!instance.isTemporarySkill()) continue;
            instance.decreaseRemoveTime(1);
            if (!instance.shouldRemove()) continue;
            skillStorage.forgetSkill(instance);
            skillStorage.syncChanges();
            break;
        }
    }
}

