/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.capability.skill.event;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.TickingSkill;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.SkillDamageEvent;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.manascore.capability.skill.event.TickEventListenerHandler;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="manascore", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEventListenerHandler {
    @SubscribeEvent
    public static void onUnlockSkill(UnlockSkillEvent e) {
        Entity entity = e.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            e.getSkillInstance().onLearnSkill(living, e);
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent e) {
        if (e.getEntity().m_9236_().m_5776_()) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new SkillDamageEvent.PreCalculation(e));
        MinecraftForge.EVENT_BUS.post((Event)new SkillDamageEvent.Calculation(e));
        MinecraftForge.EVENT_BUS.post((Event)new SkillDamageEvent.PostCalculation(e));
        SkillAPI.getSkillsFrom((Entity)e.getEntity()).syncChanges();
    }

    @SubscribeEvent
    public static void onPreBarrierDamage(SkillDamageEvent.PreCalculation e) {
        Entity entity = e.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)living);
            for (ManasSkillInstance instance : List.copyOf(skillStorage.getLearnedSkills())) {
                ManasSkillInstance skillInstance;
                Optional<ManasSkillInstance> optional = skillStorage.getSkill(instance.getSkill());
                if (optional.isEmpty() || !(skillInstance = optional.get()).canInteractSkill(living)) continue;
                skillInstance.onDamageEntity(living, e.getEvent());
            }
        }
    }

    @SubscribeEvent
    public static void onPostBarrierDamage(SkillDamageEvent.PostCalculation e) {
        Entity entity = e.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)living);
            for (ManasSkillInstance instance : List.copyOf(skillStorage.getLearnedSkills())) {
                ManasSkillInstance skillInstance;
                Optional<ManasSkillInstance> optional = skillStorage.getSkill(instance.getSkill());
                if (optional.isEmpty() || !(skillInstance = optional.get()).canInteractSkill(living)) continue;
                skillInstance.onTouchEntity(living, e.getEvent());
            }
        }
    }

    @SubscribeEvent
    public static void onBeingTargeted(LivingChangeTargetEvent e) {
        LivingEntity target = e.getNewTarget();
        if (target == null) {
            return;
        }
        SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)target);
        for (ManasSkillInstance instance : List.copyOf(skillStorage.getLearnedSkills())) {
            ManasSkillInstance skillInstance;
            Optional<ManasSkillInstance> optional = skillStorage.getSkill(instance.getSkill());
            if (optional.isEmpty() || !(skillInstance = optional.get()).canInteractSkill(target)) continue;
            skillInstance.onBeingTargeted(target, e);
        }
        skillStorage.syncChanges();
    }

    @SubscribeEvent
    public static void onBeingDamaged(LivingAttackEvent e) {
        LivingEntity living = e.getEntity();
        SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)living);
        for (ManasSkillInstance instance : List.copyOf(skillStorage.getLearnedSkills())) {
            ManasSkillInstance skillInstance;
            Optional<ManasSkillInstance> optional = skillStorage.getSkill(instance.getSkill());
            if (optional.isEmpty() || !(skillInstance = optional.get()).canInteractSkill(living)) continue;
            skillInstance.onBeingDamaged(e);
        }
        skillStorage.syncChanges();
    }

    @SubscribeEvent
    public static void onTakingReducedDamage(LivingDamageEvent e) {
        LivingEntity living = e.getEntity();
        SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)living);
        for (ManasSkillInstance instance : List.copyOf(skillStorage.getLearnedSkills())) {
            ManasSkillInstance skillInstance;
            Optional<ManasSkillInstance> optional = skillStorage.getSkill(instance.getSkill());
            if (optional.isEmpty() || !(skillInstance = optional.get()).canInteractSkill(living)) continue;
            skillInstance.onTakenDamage(e);
        }
        skillStorage.syncChanges();
    }

    @SubscribeEvent
    public static void onProjectileHit(ProjectileImpactEvent e) {
        HitResult hitResult = e.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult result = (EntityHitResult)hitResult;
        Entity entity = result.m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)living);
        for (ManasSkillInstance instance : List.copyOf(skillStorage.getLearnedSkills())) {
            Projectile projectile;
            ManasSkillInstance skillInstance;
            Optional<ManasSkillInstance> optional = skillStorage.getSkill(instance.getSkill());
            if (optional.isEmpty() || !(skillInstance = optional.get()).canInteractSkill(living)) continue;
            skillInstance.onProjectileHit(living, e);
            if (!e.isCanceled() || !((projectile = e.getProjectile()) instanceof AbstractArrow)) continue;
            AbstractArrow arrow = (AbstractArrow)projectile;
            if (arrow.f_36701_ == null) {
                arrow.f_36701_ = new IntOpenHashSet(10);
            }
            arrow.f_36701_.add(living.m_19879_());
        }
        skillStorage.syncChanges();
    }

    @SubscribeEvent
    static void onRightClickBlock(PlayerInteractEvent.RightClickBlock e) {
        Player player = e.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)player);
        for (ManasSkillInstance instance : List.copyOf(skillStorage.getLearnedSkills())) {
            ManasSkillInstance skillInstance;
            Optional<ManasSkillInstance> optional = skillStorage.getSkill(instance.getSkill());
            if (optional.isEmpty() || !(skillInstance = optional.get()).canInteractSkill((LivingEntity)player)) continue;
            skillInstance.onRightClickBlock((LivingEntity)player, e.getHitVec());
        }
        skillStorage.syncChanges();
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        Player player = e.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)player);
        for (ManasSkillInstance instance : List.copyOf(skillStorage.getLearnedSkills())) {
            ManasSkillInstance skillInstance;
            Optional<ManasSkillInstance> optional = skillStorage.getSkill(instance.getSkill());
            if (optional.isEmpty() || !(skillInstance = optional.get()).canInteractSkill((LivingEntity)player)) continue;
            skillInstance.onRespawn(e);
            if (!skillInstance.isToggled()) continue;
            skillInstance.onToggleOn((LivingEntity)player);
        }
        skillStorage.syncChanges();
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent e) {
        LivingEntity living = e.getEntity();
        if (living.m_9236_().m_5776_()) {
            return;
        }
        SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)living);
        for (ManasSkillInstance instance : List.copyOf(skillStorage.getLearnedSkills())) {
            ManasSkillInstance skillInstance;
            Optional<ManasSkillInstance> optional = skillStorage.getSkill(instance.getSkill());
            if (optional.isEmpty() || !(skillInstance = optional.get()).canInteractSkill(living)) continue;
            skillInstance.onDeath(e);
        }
        skillStorage.syncChanges();
    }

    @SubscribeEvent
    public static void onLogOut(PlayerEvent.PlayerLoggedOutEvent e) {
        Multimap<UUID, TickingSkill> multimap = TickEventListenerHandler.tickingSkills;
        Player player = e.getEntity();
        if (multimap.containsKey((Object)player.m_20148_())) {
            for (TickingSkill tickingSkill : multimap.get((Object)player.m_20148_())) {
                ManasSkillInstance instance = tickingSkill.getSkillInstance(SkillAPI.getSkillsFrom((Entity)player), (LivingEntity)player);
                if (instance == null) continue;
                instance.removeHeldAttributeModifiers((LivingEntity)player);
            }
            multimap.removeAll((Object)player.m_20148_());
        }
    }

    @SubscribeEvent
    public static void onChangingDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        Multimap<UUID, TickingSkill> multimap = TickEventListenerHandler.tickingSkills;
        Player player = e.getEntity();
        if (multimap.containsKey((Object)player.m_20148_())) {
            for (TickingSkill tickingSkill : multimap.get((Object)player.m_20148_())) {
                ManasSkillInstance instance = tickingSkill.getSkillInstance(SkillAPI.getSkillsFrom((Entity)player), (LivingEntity)player);
                if (instance == null) continue;
                instance.removeHeldAttributeModifiers((LivingEntity)player);
            }
            multimap.removeAll((Object)player.m_20148_());
        }
    }
}

