/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.capability.skill.event;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.event.SkillScrollEvent;
import com.github.manasmods.manascore.network.ManasCoreNetwork;
import com.github.manasmods.manascore.network.toserver.RequestSkillScrollPacket;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="manascore", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEventListenerHandler {
    @SubscribeEvent
    public static void clientMouseScrolled(InputEvent.MouseScrollingEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        ArrayList<ResourceLocation> packetSkills = new ArrayList<ResourceLocation>();
        double delta = event.getScrollDelta();
        for (ManasSkillInstance skillInstance : SkillAPI.getSkillsFrom((Entity)player).getLearnedSkills()) {
            SkillScrollEvent scrollEvent = new SkillScrollEvent(skillInstance, (Player)player, event.getScrollDelta());
            if (MinecraftForge.EVENT_BUS.post((Event)scrollEvent)) continue;
            packetSkills.add(skillInstance.getSkillId());
            delta = scrollEvent.getScrollDelta();
        }
        if (!packetSkills.isEmpty()) {
            ManasCoreNetwork.INSTANCE.sendToServer((Object)new RequestSkillScrollPacket(packetSkills, delta));
            event.setCanceled(true);
        }
    }
}

