/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.capability.skill;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TestSkill
extends ManasSkill {
    private static final Logger log = LogManager.getLogger(TestSkill.class);
    protected static final String TEST = "e83b2e47-ef49-4af5-b5da-4fd14a5c8777";

    public TestSkill() {
        MinecraftForge.EVENT_BUS.addListener(this::unlock);
        this.addHeldAttributeModifier(Attributes.f_22279_, TEST, 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    @Override
    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return entity.m_6144_();
    }

    @Override
    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        log.debug("Toggled On");
    }

    @Override
    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        log.debug("Toggled Off");
    }

    @Override
    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        log.debug("I'm pressed");
    }

    @Override
    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        log.debug("Held for {} ticks", (Object)heldTicks);
        return true;
    }

    @Override
    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        log.debug("I'm released after {} ticks", (Object)heldTicks);
    }

    @Override
    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        Player player;
        if (living instanceof Player && (player = (Player)living).m_36341_()) {
            log.debug("You're sneaky");
        }
    }

    @Override
    public void onScroll(ManasSkillInstance instance, LivingEntity living, double delta) {
        log.debug("Scroll delta: {}", (Object)delta);
    }

    @Override
    public void onLearnSkill(ManasSkillInstance instance, LivingEntity living, UnlockSkillEvent e) {
        log.debug("Learnt test skill");
    }

    @Override
    public void onRightClickBlock(ManasSkillInstance instance, LivingEntity entity, BlockHitResult hitResult) {
        log.debug("Block: {}", (Object)entity.m_9236_().m_8055_(hitResult.m_82425_()).m_60734_().m_49954_());
    }

    @Override
    public void onBeingTargeted(ManasSkillInstance instance, LivingEntity target, LivingChangeTargetEvent event) {
        if (event.getEntity() instanceof Spider) {
            log.debug("Targeted by {}", (Object)event.getEntity().m_7755_());
        }
    }

    @Override
    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (event.getSource().equals(DamageSource.f_19314_)) {
            log.debug("No cactus touchy");
            event.setCanceled(true);
        }
    }

    @Override
    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Creeper) {
            Creeper creeper = (Creeper)livingEntity;
            creeper.m_6074_();
            log.debug("No creeper");
        }
    }

    @Override
    public void onTouchEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        instance.setMastery(instance.getMastery() + 1);
        log.debug("My mastery is {}", (Object)instance.getMastery());
    }

    @Override
    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
        float amount = event.getAmount() / 2.0f;
        event.getEntity().m_5634_(amount);
        log.debug("Healed {} by {} health", (Object)event.getEntity().m_7755_().getString(), (Object)Float.valueOf(amount));
    }

    @Override
    public void onProjectileHit(ManasSkillInstance instance, LivingEntity living, ProjectileImpactEvent event) {
        if (event.getProjectile() instanceof AbstractArrow) {
            log.debug("Dodged");
            event.setCanceled(true);
        }
    }

    @Override
    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        log.debug("Welcome to the phantom realm");
    }

    @Override
    public void onRespawn(ManasSkillInstance instance, PlayerEvent.PlayerRespawnEvent event) {
        log.debug("Welcome to the living realm");
    }

    private void unlock(LivingEntityUseItemEvent.Finish e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (e.getItem().m_150930_(Items.f_42410_) && SkillAPI.getSkillsFrom((Entity)player).learnSkill(this)) {
                log.debug("Unlocked example Test skill for player {}", (Object)player.m_7755_().getString());
            }
        }
    }
}

