/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.capability.skill;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.network.ManasCoreNetwork;
import com.github.manasmods.manascore.network.toclient.SyncSkillsPacket;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface InternalSkillStorage
extends SkillStorage {
    default public List<ManasSkillInstance> getDirtySkills() {
        return this.getLearnedSkills().parallelStream().filter(ManasSkillInstance::isDirty).toList();
    }

    public void setOwner(Entity var1);

    public Entity getOwner();

    default public void sync(SyncSkillsPacket.SyncType syncType) {
        if (this.getOwner() == null) {
            return;
        }
        if (this.getOwner().f_19853_.m_5776_()) {
            return;
        }
        if (this.getOwner() instanceof ServerPlayer) {
            ManasCoreNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getOwner), (Object)new SyncSkillsPacket(this.getOwner(), this, syncType));
        } else {
            ManasCoreNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(this::getOwner), (Object)new SyncSkillsPacket(this.getOwner(), this, syncType));
        }
    }

    @Override
    default public void syncAll() {
        this.sync(SyncSkillsPacket.SyncType.FULL);
    }

    @Override
    default public void syncChanges() {
        this.sync(SyncSkillsPacket.SyncType.CHANGES_ONLY);
    }

    @Override
    default public void syncPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ManasCoreNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncSkillsPacket(this.getOwner(), this, SyncSkillsPacket.SyncType.FULL));
        }
    }

    public void updateSkill(ManasSkillInstance var1, boolean var2);

    @Override
    default public void updateSkill(ManasSkillInstance updatedInstance) {
        this.updateSkill(updatedInstance, true);
    }

    @Override
    default public void updateSkills(List<ManasSkillInstance> updatedInstances) {
        updatedInstances.forEach(skillInstance -> this.updateSkill((ManasSkillInstance)skillInstance, false));
        this.syncChanges();
    }

    @Override
    default public void updateSkills(ManasSkillInstance ... updatedInstances) {
        for (ManasSkillInstance skill : updatedInstances) {
            this.updateSkill(skill, false);
        }
        this.syncChanges();
    }

    @Override
    default public boolean learnSkill(ManasSkill skill) {
        return this.learnSkill(skill.createDefaultInstance());
    }

    @Override
    default public void forgetSkill(ManasSkill skill) {
        this.getLearnedSkills().removeIf(instance -> instance.getSkillId().equals((Object)SkillAPI.getSkillRegistry().getKey((Object)skill)));
    }

    @Override
    default public void forgetSkill(ManasSkillInstance skill) {
        this.forgetSkill(skill.getSkill());
    }
}

