/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.capability.skill;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.event.RemoveSkillEvent;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.manascore.capability.skill.InternalSkillStorage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EntitySkillCapabilityStorage
implements InternalSkillStorage {
    private static final Logger log = LogManager.getLogger(EntitySkillCapabilityStorage.class);
    private final HashMap<ResourceLocation, ManasSkillInstance> skillInstances = new HashMap();
    @Nullable
    private Entity owner;

    @Override
    public Collection<ManasSkillInstance> getLearnedSkills() {
        return this.skillInstances.values();
    }

    @Override
    public void updateSkill(ManasSkillInstance updatedInstance, boolean sync) {
        updatedInstance.markDirty();
        this.skillInstances.put(updatedInstance.getSkillId(), updatedInstance);
        if (sync) {
            this.syncChanges();
        }
    }

    @Override
    public boolean learnSkill(ManasSkillInstance instance) {
        if (this.owner == null) {
            return false;
        }
        if (this.skillInstances.containsKey(instance.getSkillId())) {
            log.debug("Tried to register a deduplicate of {} to {}.", (Object)instance.getSkillId(), (Object)this.owner.m_7755_().getString());
            return false;
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)new UnlockSkillEvent(instance, this.owner))) {
            instance.markDirty();
            this.skillInstances.put(instance.getSkillId(), instance);
            this.syncChanges();
            return true;
        }
        return false;
    }

    @Override
    public Optional<ManasSkillInstance> getSkill(ManasSkill skill) {
        return this.skillInstances.values().parallelStream().filter(skillInstance -> skillInstance.getSkill().equals(skill)).findFirst();
    }

    @Override
    public void forgetSkill(ManasSkillInstance instance) {
        if (this.owner == null) {
            return;
        }
        if (!this.skillInstances.containsKey(instance.getSkillId())) {
            return;
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)new RemoveSkillEvent(instance, this.owner))) {
            instance.markDirty();
            this.getLearnedSkills().remove(instance);
            this.syncChanges();
        }
    }

    @Override
    public void forgetSkill(ManasSkill skill) {
        if (this.owner == null) {
            return;
        }
        Optional<ManasSkillInstance> optional = this.getSkill(skill);
        if (optional.isEmpty()) {
            return;
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)new RemoveSkillEvent(optional.get(), this.owner))) {
            optional.get().markDirty();
            this.getLearnedSkills().remove(optional.get());
            this.syncChanges();
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag skillList = new ListTag();
        this.skillInstances.values().forEach(instance -> skillList.add((Object)instance.toNBT()));
        tag.m_128365_("skills", (Tag)skillList);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("resetExistingData")) {
            this.skillInstances.clear();
        }
        for (Tag tag : nbt.m_128437_("skills", 10)) {
            if (!(tag instanceof CompoundTag)) {
                log.error("Tag is not a Compound! Exception while deserializing tag {}.", (Object)tag);
                continue;
            }
            CompoundTag compoundTag = (CompoundTag)tag;
            try {
                ManasSkillInstance instance = ManasSkillInstance.fromNBT(compoundTag);
                this.skillInstances.put(instance.getSkillId(), instance);
            }
            catch (Exception exception) {
                log.error("Exception while deserializing tag {}.\n{}", (Object)tag, (Object)exception);
            }
        }
    }

    @Override
    @Nullable
    public Entity getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(@Nullable Entity owner) {
        this.owner = owner;
    }
}

