/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.capability.skill;

import com.github.manasmods.manascore.capability.GenericCapabilityProvider;
import com.github.manasmods.manascore.capability.skill.EntitySkillCapabilityStorage;
import com.github.manasmods.manascore.capability.skill.InternalSkillStorage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EntitySkillCapability {
    static final Capability<InternalSkillStorage> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<InternalSkillStorage>(){});
    private static final ResourceLocation ID = new ResourceLocation("manascore", "skills");

    private static void register(RegisterCapabilitiesEvent e) {
        e.register(InternalSkillStorage.class);
    }

    private static void attach(AttachCapabilitiesEvent<Entity> e) {
        e.addCapability(ID, new GenericCapabilityProvider<InternalSkillStorage>(CAP, EntitySkillCapabilityStorage::new));
    }

    private static void login(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EntitySkillCapability.load((Entity)player2).syncAll();
        }
    }

    private static void clonePlayer(PlayerEvent.Clone e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            e.getOriginal().reviveCaps();
            InternalSkillStorage skillStorage = EntitySkillCapability.load((Entity)e.getOriginal());
            InternalSkillStorage newStorage = EntitySkillCapability.load((Entity)player2);
            newStorage.deserializeNBT((Tag)((CompoundTag)skillStorage.serializeNBT()));
            e.getOriginal().invalidateCaps();
            newStorage.syncAll();
        }
    }

    private static void respawn(PlayerEvent.PlayerRespawnEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EntitySkillCapability.load((Entity)player2).syncAll();
        }
    }

    private static void changeDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EntitySkillCapability.load((Entity)player2).syncAll();
        }
    }

    private static void startTracking(PlayerEvent.StartTracking e) {
        EntitySkillCapability.load(e.getTarget()).syncPlayer(e.getEntity());
    }

    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(EntitySkillCapability::register);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addGenericListener(Entity.class, EntitySkillCapability::attach);
        forgeEventBus.addListener(EntitySkillCapability::login);
        forgeEventBus.addListener(EntitySkillCapability::clonePlayer);
        forgeEventBus.addListener(EntitySkillCapability::respawn);
        forgeEventBus.addListener(EntitySkillCapability::changeDimension);
        forgeEventBus.addListener(EntitySkillCapability::startTracking);
    }

    public static InternalSkillStorage load(Entity entity) {
        InternalSkillStorage cap = (InternalSkillStorage)entity.getCapability(CAP).orElseGet(EntitySkillCapabilityStorage::new);
        cap.setOwner(entity);
        return cap;
    }
}

