/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.attribute;

import com.github.manasmods.manascore.api.attribute.event.ArrowCriticalChanceEvent;
import com.github.manasmods.manascore.api.attribute.event.CriticalChanceEvent;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber(modid="manascore", bus=Mod.EventBusSubscriber.Bus.FORGE)
@ApiStatus.Internal
public class ManasCoreAttributeHandler {
    @SubscribeEvent
    public static void modifyJumpPower(LivingEvent.LivingJumpEvent e) {
        AttributeInstance instance = e.getEntity().m_21051_((Attribute)ManasCoreAttributes.JUMP_POWER.get());
        if (instance == null) {
            return;
        }
        LivingEntity entity = e.getEntity();
        BlockPos entityPos = entity.m_20183_();
        double baseJumpPower = instance.m_22135_();
        float blockModifier0 = entity.f_19853_.m_8055_(entityPos).m_60734_().m_49964_();
        float blockModifier1 = entity.f_19853_.m_8055_(new BlockPos((double)entityPos.m_123341_(), entity.m_20191_().f_82289_ - 0.5000001, (double)entityPos.m_123343_())).m_60734_().m_49964_();
        double blockModifier = (double)blockModifier0 == 1.0 ? (double)blockModifier1 : (double)blockModifier0;
        double jumpPower = baseJumpPower * blockModifier;
        double verticalVelocity = jumpPower + entity.m_182332_();
        Vec3 vec3 = entity.m_20184_();
        entity.m_20334_(vec3.f_82479_, verticalVelocity, vec3.f_82481_);
        entity.f_19812_ = true;
    }

    @SubscribeEvent
    public static void modifyFallDamage(LivingFallEvent e) {
        AttributeInstance instance = e.getEntity().m_21051_((Attribute)ManasCoreAttributes.JUMP_POWER.get());
        if (instance == null) {
            return;
        }
        if (instance.m_22135_() == 0.42) {
            return;
        }
        double additionalJumpBlock = (instance.m_22135_() - 0.42) / 0.2;
        e.setDistance((float)((double)e.getDistance() - additionalJumpBlock));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void applyEntityCrit(LivingHurtEvent e) {
        Entity entity = e.getSource().m_7640_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (entity2 instanceof Player) {
            return;
        }
        LivingEntity target = e.getEntity();
        double critChance = entity2.m_21133_((Attribute)ManasCoreAttributes.CRIT_CHANCE.get()) / 100.0;
        float critMultiplier = (float)entity2.m_21133_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get());
        CriticalChanceEvent event = new CriticalChanceEvent(entity2, (Entity)target, critMultiplier, critChance);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        RandomSource random = entity2.m_217043_();
        if ((double)random.m_188501_() > event.getCritChance()) {
            return;
        }
        e.setAmount(e.getAmount() * event.getDamageModifier());
        target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12313_, entity2.m_5720_(), 1.0f, 1.0f);
        Level level = entity2.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_7726_().m_8394_((Entity)entity2, (Packet)new ClientboundAnimatePacket((Entity)target, 4));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void modifyCrit(CriticalHitEvent e) {
        float vanillaMultiplier = e.getDamageModifier() / e.getOldDamageModifier();
        float critMultiplier = (float)e.getEntity().m_21133_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get());
        if (e.isVanillaCritical()) {
            e.setDamageModifier(vanillaMultiplier * critMultiplier);
            return;
        }
        double critChance = e.getEntity().m_21133_((Attribute)ManasCoreAttributes.CRIT_CHANCE.get()) / 100.0;
        CriticalChanceEvent event = new CriticalChanceEvent((LivingEntity)e.getEntity(), e.getTarget(), vanillaMultiplier * critMultiplier, critChance);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        RandomSource random = e.getEntity().m_217043_();
        if ((double)random.m_188501_() > event.getCritChance()) {
            return;
        }
        e.setDamageModifier(event.getDamageModifier());
        e.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public static void modifyArrowCrit(EntityJoinLevelEvent e) {
        if (e.getLevel().f_46443_) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)entity;
        if (arrow.getPersistentData().m_128471_("manascore.crit.calc.done")) {
            return;
        }
        Entity entity2 = arrow.m_37282_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity2;
        if (!arrow.m_36792_()) {
            double critChance = owner.m_21133_((Attribute)ManasCoreAttributes.CRIT_CHANCE.get());
            ArrowCriticalChanceEvent event = new ArrowCriticalChanceEvent(owner, (Projectile)arrow, critChance);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            arrow.m_36762_(owner.m_217043_().m_188500_() <= event.getCritChance());
        }
        arrow.getPersistentData().m_128379_("manascore.crit.calc.done", true);
    }

    @SubscribeEvent
    public static void modifyMiningSpeed(PlayerEvent.BreakSpeed e) {
        AttributeInstance instance = e.getEntity().m_21051_((Attribute)ManasCoreAttributes.MINING_SPEED_MULTIPLIER.get());
        if (instance == null) {
            return;
        }
        e.setNewSpeed((float)((double)e.getOriginalSpeed() * instance.m_22135_()));
    }
}

