/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.world.gen.biome;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0.0")
public class MobSpawnHelper {
    private final MobSpawnSettings.Builder mobSpawnSettings;

    public MobSpawnHelper() {
        this.mobSpawnSettings = new MobSpawnSettings.Builder();
    }

    public static MobSpawnHelper from(MobSpawnSettings.Builder mobSpawnSettings) {
        return new MobSpawnHelper(mobSpawnSettings);
    }

    public MobSpawnSettings.Builder toBuilder() {
        return this.mobSpawnSettings;
    }

    public MobSpawnSettings finishMobSpawnSettings() {
        return this.mobSpawnSettings.m_48381_();
    }

    public MobSpawnHelper apply(DefaultBiomeMobSpawnSettings defaultBiomeFeature) {
        defaultBiomeFeature.apply(this.mobSpawnSettings);
        return this;
    }

    public MobSpawnHelper apply(DefaultBiomeMobSpawnSettings defaultBiomeFeature, DefaultBiomeMobSpawnSettings ... defaultBiomeFeatures) {
        this.apply(defaultBiomeFeature);
        for (DefaultBiomeMobSpawnSettings feature : defaultBiomeFeatures) {
            this.apply(feature);
        }
        return this;
    }

    public MobSpawnHelper addSpawn(MobCategory category, EntityType<?> entityType, int weight, int minCount, int maxCount) {
        this.mobSpawnSettings.m_48376_(category, new MobSpawnSettings.SpawnerData(entityType, weight, minCount, maxCount));
        return this;
    }

    public MobSpawnHelper(MobSpawnSettings.Builder mobSpawnSettings) {
        this.mobSpawnSettings = mobSpawnSettings;
    }

    @FunctionalInterface
    public static interface DefaultBiomeMobSpawnSettings {
        public void apply(MobSpawnSettings.Builder var1);
    }
}

