/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.world.gen.biome;

import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0.0")
public class BiomeGenerationSettingsHelper {
    private final BiomeGenerationSettings.Builder biomeGenSettings;

    public BiomeGenerationSettingsHelper() {
        this.biomeGenSettings = new BiomeGenerationSettings.Builder();
    }

    public static BiomeGenerationSettingsHelper from(BiomeGenerationSettings.Builder biomeGenSettings) {
        return new BiomeGenerationSettingsHelper(biomeGenSettings);
    }

    public BiomeGenerationSettings.Builder toBuilder() {
        return this.biomeGenSettings;
    }

    public BiomeGenerationSettingsHelper apply(DefaultBiomeFeature defaultBiomeFeature) {
        defaultBiomeFeature.apply(this.biomeGenSettings);
        return this;
    }

    public BiomeGenerationSettingsHelper apply(DefaultBiomeFeature defaultBiomeFeature, DefaultBiomeFeature ... defaultBiomeFeatures) {
        this.apply(defaultBiomeFeature);
        for (DefaultBiomeFeature feature : defaultBiomeFeatures) {
            this.apply(feature);
        }
        return this;
    }

    public BiomeGenerationSettingsHelper addCarver(GenerationStep.Carving generationStep, Holder<? extends ConfiguredWorldCarver<?>> carver) {
        this.biomeGenSettings.m_204198_(generationStep, carver);
        return this;
    }

    public BiomeGenerationSettingsHelper addFeature(GenerationStep.Decoration generationStep, Holder<PlacedFeature> feature) {
        this.biomeGenSettings.m_204201_(generationStep, feature);
        return this;
    }

    public BiomeGenerationSettings finishBiomeSettings() {
        return this.biomeGenSettings.m_47831_();
    }

    public BiomeGenerationSettingsHelper(BiomeGenerationSettings.Builder biomeGenSettings) {
        this.biomeGenSettings = biomeGenSettings;
    }

    @FunctionalInterface
    public static interface DefaultBiomeFeature {
        public void apply(BiomeGenerationSettings.Builder var1);
    }
}

