/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.world.gen.biome;

import com.github.manasmods.manascore.api.world.gen.biome.BiomeGenerationSettingsHelper;
import com.github.manasmods.manascore.api.world.gen.biome.MobSpawnHelper;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.sounds.Music;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="2.0.0.0")
public class BiomeBuilder {
    private final BiomeGenerationSettingsHelper generationSettingsHelper;
    private final MobSpawnHelper mobSpawnHelper;
    private final Biome.BiomeBuilder biomeBuilder = new Biome.BiomeBuilder();
    private Biome.Precipitation rainType = Biome.Precipitation.RAIN;
    private float temperature = 0.8f;
    private float downfall = 0.4f;
    private int waterColor = 4159204;
    private int waterFogColor = 329011;
    private int fogColor = 12638463;
    private Music backgroundMusic = null;
    private Optional<Integer> grassColorOverride = Optional.empty();
    private BiomeSpecialEffects.GrassColorModifier grassColorModifier = BiomeSpecialEffects.GrassColorModifier.NONE;

    public BiomeBuilder grassColor(Color color) {
        this.grassColorOverride = Optional.of(color.getRGB());
        return this;
    }

    public BiomeBuilder grassModifier(BiomeSpecialEffects.GrassColorModifier grassColorModifier) {
        this.grassColorModifier = grassColorModifier;
        return this;
    }

    public BiomeBuilder downfall(float downfall) {
        this.downfall = downfall;
        return this;
    }

    public BiomeBuilder waterColor(Color color) {
        this.waterColor = color.getRGB();
        return this;
    }

    public BiomeBuilder waterFogColor(Color color) {
        this.waterFogColor = color.getRGB();
        return this;
    }

    public BiomeBuilder fogColor(Color color) {
        this.fogColor = color.getRGB();
        return this;
    }

    public BiomeBuilder backgroundMusic(Music music) {
        this.backgroundMusic = music;
        return this;
    }

    public BiomeBuilder temperature(float temperature) {
        this.temperature = temperature;
        return this;
    }

    public BiomeBuilder rain(Biome.Precipitation rainType) {
        this.rainType = rainType;
        return this;
    }

    public Biome build() {
        BiomeSpecialEffects.Builder specialEffects = new BiomeSpecialEffects.Builder().m_48034_(this.waterColor).m_48037_(this.waterFogColor).m_48019_(this.fogColor).m_48040_(BiomeBuilder.calculateSkyColor(this.temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(this.backgroundMusic).m_48031_(this.grassColorModifier);
        this.grassColorOverride.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)specialEffects).m_48045_(arg_0));
        return this.biomeBuilder.m_47597_(this.rainType).m_47609_(this.temperature).m_47611_(this.downfall).m_47603_(specialEffects.m_48018_()).m_47605_(this.mobSpawnHelper.finishMobSpawnSettings()).m_47601_(this.generationSettingsHelper.finishBiomeSettings()).m_47592_();
    }

    public static BiomeBuilder forest(BiomeGenerationSettingsHelper generationSettingsHelper, MobSpawnHelper mobSpawnHelper) {
        return new BiomeBuilder(generationSettingsHelper, mobSpawnHelper).temperature(0.7f).downfall(0.8f);
    }

    private static int calculateSkyColor(float p_194844_) {
        float $$1 = p_194844_ / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    public BiomeBuilder(BiomeGenerationSettingsHelper generationSettingsHelper, MobSpawnHelper mobSpawnHelper) {
        this.generationSettingsHelper = generationSettingsHelper;
        this.mobSpawnHelper = mobSpawnHelper;
    }

    public void setRainType(Biome.Precipitation rainType) {
        this.rainType = rainType;
    }
}

