/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.util;

import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtils {
    private static final Logger log = LogManager.getLogger(ReflectionUtils.class);

    @Nullable
    public static <T> RegistryObject<T> getRegistryObjectFromField(ModFileScanData.AnnotationData annotationData, Field field, Class<T> type) {
        Objects.requireNonNull(type);
        try {
            field.setAccessible(true);
            return (RegistryObject)field.get(null);
        }
        catch (IllegalAccessException e) {
            log.error("Could not load data from field {} in class {}", (Object)field.getName(), (Object)annotationData.clazz().getClassName());
            log.throwing((Throwable)e);
        }
        catch (ClassCastException e) {
            log.error("Could not cast field {} in class {} to RegistryObject<{}> type", (Object)field.getName(), (Object)annotationData.clazz().getClassName(), (Object)type.getName());
            log.throwing((Throwable)e);
        }
        return null;
    }

    @Nullable
    public static <T> DeferredRegister<T> getDeferredRegisterFromField(ModFileScanData.AnnotationData annotationData, Field field, Class<T> type) {
        Objects.requireNonNull(type);
        try {
            field.setAccessible(true);
            return (DeferredRegister)field.get(null);
        }
        catch (IllegalAccessException e) {
            log.error("Could not load data from field {} in class {}", (Object)field.getName(), (Object)annotationData.clazz().getClassName());
            log.throwing((Throwable)e);
        }
        catch (ClassCastException e) {
            log.error("Could not cast field {} in class {} to RegistryObject<{}> type", (Object)field.getName(), (Object)annotationData.clazz().getClassName(), (Object)type.getName());
            log.throwing((Throwable)e);
        }
        return null;
    }
}

