/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.tab;

import com.github.manasmods.manascore.tab.IInventoryTab;
import com.github.manasmods.manascore.tab.TabPosition;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0.0")
public abstract class AbstractInventoryTab
extends Button
implements IInventoryTab {
    protected static final int TAB_WIDTH = 28;
    protected static final int TAB_HEIGHT = 32;
    private final List<FormattedCharSequence> tooltip;
    protected final Minecraft minecraft = Minecraft.m_91087_();
    private TabPosition position;

    public AbstractInventoryTab(MutableComponent tooltip, MutableComponent ... tooltips) {
        super(0, 0, 28, 32, (Component)Component.m_237119_(), pButton -> {
            AbstractInventoryTab tab = (AbstractInventoryTab)pButton;
            tab.sendOpenContainerPacket();
        }, (pButton, pPoseStack, pMouseX, pMouseY) -> {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen == null) {
                return;
            }
            AbstractInventoryTab tab = (AbstractInventoryTab)pButton;
            screen.m_96617_(pPoseStack, tab.tooltip, pMouseX, pMouseY);
        });
        this.tooltip = Stream.concat(Stream.of(tooltip), Arrays.stream(tooltips)).map(Component::m_7532_).toList();
    }

    public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        this.m_7906_(pPoseStack, this.minecraft, pMouseX, pMouseY);
        this.renderIcon(pPoseStack, pMouseX, pMouseY, pPartialTick);
        if (this.m_198029_()) {
            this.m_7428_(pPoseStack, pMouseX, pMouseY);
        }
    }

    protected abstract void renderIcon(PoseStack var1, int var2, int var3, float var4);

    protected void m_7906_(PoseStack pPoseStack, Minecraft pMinecraft, int pMouseX, int pMouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        this.position.bindTexture();
        float yOffset = this.isCurrent() ? 32.0f : 0.0f;
        AbstractInventoryTab.m_93160_((PoseStack)pPoseStack, (int)this.f_93620_, (int)this.f_93621_, (int)28, (int)32, (float)0.0f, (float)yOffset, (int)28, (int)31, (int)28, (int)64);
    }

    public boolean isCurrent() {
        return this.isCurrentScreen().test(this.minecraft.f_91080_);
    }

    public TabPosition getPosition() {
        return this.position;
    }

    public void setPosition(TabPosition position) {
        this.position = position;
    }
}

