/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.skills;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.capability.skill.EntitySkillCapability;
import com.github.manasmods.manascore.capability.skill.event.InternalSkillPacketActions;
import com.github.manasmods.manascore.skill.SkillRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
@ApiStatus.AvailableSince(value="1.0.2.0")
public final class SkillAPI {
    @NotNull
    public static IForgeRegistry<ManasSkill> getSkillRegistry() {
        return SkillRegistry.REGISTRY.get();
    }

    @NotNull
    public static ResourceLocation getSkillRegistryKey() {
        return SkillRegistry.REGISTRY_KEY;
    }

    @NotNull
    public static SkillStorage getSkillsFrom(Entity entity) {
        return EntitySkillCapability.load(entity);
    }

    public static void skillActivationPacket(ResourceLocation skill, int keyNumber) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> InternalSkillPacketActions.sendSkillActivationPacket(skill, keyNumber));
    }

    public static void skillReleasePacket(ResourceLocation skill, int keyNumber, int heldTicks) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> InternalSkillPacketActions.sendSkillReleasePacket(skill, keyNumber, heldTicks));
    }

    public static void skillTogglePacket(ResourceLocation skill) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> InternalSkillPacketActions.sendSkillTogglePacket(skill));
    }
}

