/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.skills;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.2.0")
public class ManasSkillInstance
implements Cloneable {
    private int mode = 1;
    private int coolDown;
    private int removeTime = -1;
    private int masteryPoint;
    private boolean toggled;
    @Nullable
    private CompoundTag tag;
    private final Holder.Reference<ManasSkill> skillRegistryObject;
    private boolean dirty = false;

    public ManasSkillInstance(ManasSkill skill) {
        this.skillRegistryObject = SkillAPI.getSkillRegistry().getDelegateOrThrow((Object)skill);
    }

    public boolean is(TagKey<ManasSkill> tag) {
        return this.skillRegistryObject.m_203656_(tag);
    }

    public ManasSkill getSkill() {
        return (ManasSkill)this.skillRegistryObject.get();
    }

    public ResourceLocation getSkillId() {
        return this.skillRegistryObject.m_205785_().m_135782_();
    }

    public ManasSkillInstance clone() {
        ManasSkillInstance clone = new ManasSkillInstance(this.getSkill());
        clone.dirty = this.dirty;
        return clone;
    }

    @ApiStatus.NonExtendable
    public final CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("skill", this.getSkillId().toString());
        this.serialize(tag);
        return tag;
    }

    public CompoundTag serialize(CompoundTag tag) {
        tag.m_128405_("Mode", this.mode);
        tag.m_128405_("CoolDown", this.coolDown);
        tag.m_128405_("RemoveTime", this.removeTime);
        tag.m_128405_("Mastery", this.masteryPoint);
        tag.m_128379_("Toggled", this.toggled);
        if (this.tag != null) {
            tag.m_128365_("tag", (Tag)this.tag.m_6426_());
        }
        return tag;
    }

    public void deserialize(CompoundTag tag) {
        this.mode = tag.m_128451_("Mode");
        this.coolDown = tag.m_128451_("CoolDown");
        this.removeTime = tag.m_128451_("RemoveTime");
        this.masteryPoint = tag.m_128451_("Mastery");
        this.toggled = tag.m_128471_("Toggled");
        if (tag.m_128425_("tag", 10)) {
            this.tag = tag.m_128469_("tag");
        }
    }

    @ApiStatus.NonExtendable
    public static ManasSkillInstance fromNBT(CompoundTag tag) {
        ResourceLocation skillLocation = ResourceLocation.m_135820_((String)tag.m_128461_("skill"));
        ManasSkillInstance instance = Objects.requireNonNull((ManasSkill)SkillAPI.getSkillRegistry().getValue(skillLocation)).createDefaultInstance();
        instance.deserialize(tag);
        return instance;
    }

    public void markDirty() {
        this.dirty = true;
    }

    @ApiStatus.Internal
    public void resetDirty() {
        this.dirty = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManasSkillInstance instance = (ManasSkillInstance)o;
        return this.getSkillId().equals((Object)instance.getSkillId()) && this.skillRegistryObject.m_205785_().m_211136_().equals((Object)instance.skillRegistryObject.m_205785_().m_211136_());
    }

    public int hashCode() {
        return Objects.hash(this.skillRegistryObject);
    }

    public boolean canInteractSkill(LivingEntity living) {
        return this.getSkill().canInteractSkill(this, living);
    }

    public int getMaxHeldTime(LivingEntity living) {
        return this.getSkill().getMaxHeldTime(this, living);
    }

    public boolean canBeToggled(LivingEntity entity) {
        return this.getSkill().canBeToggled(this, entity);
    }

    public boolean canIgnoreCoolDown(LivingEntity entity) {
        return this.getSkill().canIgnoreCoolDown(this, entity);
    }

    public boolean canTick(LivingEntity entity) {
        return this.getSkill().canTick(this, entity);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    public int getMaxMastery() {
        return this.getSkill().getMaxMastery();
    }

    public boolean isMastered(LivingEntity entity) {
        return this.getSkill().isMastered(this, entity);
    }

    public void addMasteryPoint(LivingEntity entity) {
        this.getSkill().addMasteryPoint(this, entity);
    }

    public int getMastery() {
        return this.masteryPoint;
    }

    public void setMastery(int point) {
        this.masteryPoint = point;
        this.markDirty();
    }

    public int getCoolDown() {
        return this.coolDown;
    }

    public boolean onCoolDown() {
        return this.coolDown > 0;
    }

    public void setCoolDown(int coolDown) {
        this.coolDown = coolDown;
        this.markDirty();
    }

    public void decreaseCoolDown(int coolDown) {
        this.coolDown -= coolDown;
        this.markDirty();
    }

    public boolean isTemporarySkill() {
        return this.removeTime != -1;
    }

    public boolean shouldRemove() {
        return this.removeTime == 0;
    }

    public int getRemoveTime() {
        return this.removeTime;
    }

    public void setRemoveTime(int removeTime) {
        this.removeTime = removeTime;
        this.markDirty();
    }

    public void decreaseRemoveTime(int time) {
        this.removeTime -= time;
        this.markDirty();
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void setToggled(boolean toggled) {
        this.toggled = toggled;
        this.markDirty();
    }

    @Nullable
    public CompoundTag getTag() {
        return this.tag;
    }

    public CompoundTag getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new CompoundTag());
        }
        return this.tag;
    }

    public void setTag(@Nullable CompoundTag tag) {
        this.tag = tag;
        this.markDirty();
    }

    public double getAttributeModifierAmplifier(LivingEntity entity, AttributeModifier modifier) {
        return this.getSkill().getAttributeModifierAmplifier(this, entity, modifier);
    }

    public void addHeldAttributeModifiers(LivingEntity entity) {
        this.getSkill().addHeldAttributeModifiers(this, entity);
    }

    public void removeHeldAttributeModifiers(LivingEntity entity) {
        this.getSkill().removeHeldAttributeModifiers(this, entity);
    }

    public void onToggleOn(LivingEntity entity) {
        this.getSkill().onToggleOn(this, entity);
    }

    public void onToggleOff(LivingEntity entity) {
        this.getSkill().onToggleOff(this, entity);
    }

    public void onTick(LivingEntity living) {
        this.getSkill().onTick(this, living);
    }

    public void onPressed(LivingEntity entity) {
        this.getSkill().onPressed(this, entity);
    }

    public boolean onHeld(LivingEntity entity, int heldTicks) {
        return this.getSkill().onHeld(this, entity, heldTicks);
    }

    public void onRelease(LivingEntity entity, int heldTicks) {
        this.getSkill().onRelease(this, entity, heldTicks);
    }

    public void onScroll(LivingEntity entity, double delta) {
        this.getSkill().onScroll(this, entity, delta);
    }

    public void onLearnSkill(LivingEntity living, UnlockSkillEvent event) {
        this.getSkill().onLearnSkill(this, living, event);
    }

    public void onSkillMastered(LivingEntity living) {
        this.getSkill().onSkillMastered(this, living);
    }

    public void onRightClickBlock(LivingEntity entity, BlockHitResult hitResult) {
        this.getSkill().onRightClickBlock(this, entity, hitResult);
    }

    public void onBeingTargeted(LivingEntity target, LivingChangeTargetEvent event) {
        this.getSkill().onBeingTargeted(this, target, event);
    }

    public void onBeingDamaged(LivingAttackEvent event) {
        this.getSkill().onBeingDamaged(this, event);
    }

    public void onDamageEntity(LivingEntity entity, LivingHurtEvent event) {
        this.getSkill().onDamageEntity(this, entity, event);
    }

    public void onTouchEntity(LivingEntity entity, LivingHurtEvent event) {
        this.getSkill().onTouchEntity(this, entity, event);
    }

    public void onTakenDamage(LivingDamageEvent event) {
        this.getSkill().onTakenDamage(this, event);
    }

    public void onProjectileHit(LivingEntity living, ProjectileImpactEvent event) {
        this.getSkill().onProjectileHit(this, living, event);
    }

    public void onDeath(LivingDeathEvent event) {
        this.getSkill().onDeath(this, event);
    }

    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.getSkill().onRespawn(this, event);
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

