/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.skills;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.2.0")
public class ManasSkill {
    protected final Map<Attribute, AttributeModifier> onHeldAttributeModifiers = Maps.newHashMap();

    public ManasSkillInstance createDefaultInstance() {
        return new ManasSkillInstance(this);
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return SkillAPI.getSkillRegistry().getKey((Object)this);
    }

    @Nullable
    public MutableComponent getName() {
        ResourceLocation id = this.getRegistryName();
        if (id == null) {
            return null;
        }
        return Component.m_237115_((String)String.format("%s.skill.%s", id.m_135827_(), id.m_135815_().replace('/', '.')));
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        ResourceLocation id = this.getRegistryName();
        if (id == null) {
            return null;
        }
        return new ResourceLocation(id.m_135827_(), "icons/skills/" + id.m_135815_());
    }

    public Component getSkillDescription() {
        ResourceLocation id = this.getRegistryName();
        if (id == null) {
            return Component.m_237119_();
        }
        return Component.m_237115_((String)String.format("%s.skill.%s.description", id.m_135827_(), id.m_135815_().replace('/', '.')));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManasSkill skill = (ManasSkill)o;
        return Objects.equals(this.getRegistryName(), skill.getRegistryName());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public int getMaxHeldTime(ManasSkillInstance instance, LivingEntity living) {
        return 72000;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return false;
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return false;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return false;
    }

    public int getMaxMastery() {
        return 100;
    }

    public boolean isMastered(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMastery() >= this.getMaxMastery();
    }

    public void addMasteryPoint(ManasSkillInstance instance, LivingEntity entity) {
        if (this.isMastered(instance, entity)) {
            return;
        }
        instance.setMastery(instance.getMastery() + 1);
        if (this.isMastered(instance, entity)) {
            this.onSkillMastered(instance, entity);
        }
    }

    public void addHeldAttributeModifier(Attribute pAttribute, String pUuid, double pAmount, AttributeModifier.Operation pOperation) {
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString(pUuid), Util.m_137492_((String)"skill", (ResourceLocation)this.getRegistryName()), pAmount, pOperation);
        this.onHeldAttributeModifiers.put(pAttribute, attributemodifier);
    }

    public double getAttributeModifierAmplifier(ManasSkillInstance instance, LivingEntity entity, AttributeModifier modifier) {
        return modifier.m_22218_();
    }

    public void addHeldAttributeModifiers(ManasSkillInstance instance, LivingEntity entity) {
        String descriptionId = Util.m_137492_((String)"skill", (ResourceLocation)this.getRegistryName());
        for (Map.Entry<Attribute, AttributeModifier> entry : this.onHeldAttributeModifiers.entrySet()) {
            AttributeInstance attributeinstance = entity.m_21204_().m_22146_(entry.getKey());
            if (attributeinstance == null || attributeinstance.m_22109_(entry.getValue())) continue;
            AttributeModifier attributemodifier = entry.getValue();
            attributeinstance.m_22130_(attributemodifier);
            attributeinstance.m_22125_(new AttributeModifier(attributemodifier.m_22209_(), descriptionId, instance.getAttributeModifierAmplifier(entity, attributemodifier), attributemodifier.m_22217_()));
        }
    }

    public void removeHeldAttributeModifiers(ManasSkillInstance instance, LivingEntity entity) {
        for (Map.Entry<Attribute, AttributeModifier> entry : this.onHeldAttributeModifiers.entrySet()) {
            AttributeInstance attributeinstance = entity.m_21204_().m_22146_(entry.getKey());
            if (attributeinstance == null) continue;
            attributeinstance.m_22130_(entry.getValue());
        }
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        return false;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity living, double delta) {
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity living, UnlockSkillEvent event) {
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity living) {
    }

    public void onRightClickBlock(ManasSkillInstance instance, LivingEntity entity, BlockHitResult hitResult) {
    }

    public void onBeingTargeted(ManasSkillInstance instance, LivingEntity target, LivingChangeTargetEvent event) {
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
    }

    public void onProjectileHit(ManasSkillInstance instance, LivingEntity living, ProjectileImpactEvent event) {
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
    }

    public void onRespawn(ManasSkillInstance instance, PlayerEvent.PlayerRespawnEvent event) {
    }
}

