/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.permission;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0.0")
public class PermissionHelper {
    private final String modId;

    public boolean hasPermissionOrIsConsole(CommandSourceStack sourceStack, PermissionNode<Boolean> node) {
        try {
            return (Boolean)PermissionAPI.getPermission((ServerPlayer)sourceStack.m_81375_(), node, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
        }
        catch (CommandSyntaxException e) {
            return true;
        }
    }

    public boolean hasPermissonAndIsPlayer(CommandSourceStack sourceStack, PermissionNode<Boolean> node) {
        try {
            return (Boolean)PermissionAPI.getPermission((ServerPlayer)sourceStack.m_81375_(), node, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public PermissionNode<Boolean> createNode(String node, boolean allowConsole, int permissionLevel) {
        return new PermissionNode(this.modId, node, PermissionTypes.BOOLEAN, (player, playerUUID, context) -> {
            if (player == null) {
                return allowConsole;
            }
            return player.m_20310_(permissionLevel);
        }, new PermissionDynamicContextKey[0]);
    }

    public PermissionHelper(String modId) {
        this.modId = modId;
    }
}

