/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.data.gen;

import com.github.manasmods.manascore.core.ShapedRecipeBuilderAccessor;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.AvailableSince(value="1.0.0.0")
public abstract class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider
implements IConditionBuilder {
    public RecipeProvider(GatherDataEvent gatherDataEvent) {
        super(gatherDataEvent.getGenerator());
    }

    @ApiStatus.OverrideOnly
    protected abstract void generate(Consumer<FinishedRecipe> var1);

    protected void m_176531_(@NotNull Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        this.generate(pFinishedRecipeConsumer);
    }

    @ApiStatus.AvailableSince(value="2.0.0.0")
    @ApiStatus.NonExtendable
    protected final ResourceLocation rl(Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item));
    }

    @ApiStatus.AvailableSince(value="2.0.0.0")
    @ApiStatus.NonExtendable
    protected final ResourceLocation rl(ItemStack item) {
        return this.rl(item.m_41720_());
    }

    @ApiStatus.AvailableSince(value="2.0.0.0")
    @ApiStatus.NonExtendable
    protected final ResourceLocation rl(ItemLike itemLike) {
        return this.rl(itemLike.m_5456_());
    }

    @ApiStatus.AvailableSince(value="2.0.0.0")
    @ApiStatus.NonExtendable
    protected final ResourceLocation rl(Block block) {
        return this.rl(block.m_5456_());
    }

    protected void allSmeltingRecipes(Consumer<FinishedRecipe> pFinishedRecipeConsumer, Ingredient ingredient, ItemLike result, float exp, int smeltingTicks, int campfireTicks, int smokingTicks) {
        this.smeltingRecipe(pFinishedRecipeConsumer, ingredient, result, exp, smeltingTicks);
        this.campfireRecipe(pFinishedRecipeConsumer, ingredient, result, exp, campfireTicks);
        this.smokingRecipe(pFinishedRecipeConsumer, ingredient, result, exp, smokingTicks);
    }

    protected void smeltingRecipe(Consumer<FinishedRecipe> pFinishedRecipeConsumer, Ingredient ingredient, ItemLike result, float exp, int cookingTicks) {
        for (ItemStack itemStack : ingredient.m_43908_()) {
            SimpleCookingRecipeBuilder.m_126272_((Ingredient)ingredient, (ItemLike)result, (float)exp, (int)cookingTicks).m_126132_("has_" + this.getHasName(itemStack), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)itemStack.m_41720_())).m_176500_(pFinishedRecipeConsumer, RecipeProvider.m_176656_((ItemLike)result));
        }
    }

    protected void campfireRecipe(Consumer<FinishedRecipe> pFinishedRecipeConsumer, Ingredient ingredient, ItemLike result, float exp, int cookingTicks) {
        for (ItemStack itemStack : ingredient.m_43908_()) {
            RecipeProvider.m_176583_(pFinishedRecipeConsumer, (String)"campfire_cooking", (SimpleCookingSerializer)RecipeSerializer.f_44094_, (int)cookingTicks, (ItemLike)itemStack.m_41720_(), (ItemLike)result, (float)exp);
        }
    }

    protected void smokingRecipe(Consumer<FinishedRecipe> pFinishedRecipeConsumer, Ingredient ingredient, ItemLike result, float exp, int cookingTicks) {
        for (ItemStack itemStack : ingredient.m_43908_()) {
            RecipeProvider.m_176583_(pFinishedRecipeConsumer, (String)"smoking", (SimpleCookingSerializer)RecipeSerializer.f_44093_, (int)cookingTicks, (ItemLike)itemStack.m_41720_(), (ItemLike)result, (float)exp);
        }
    }

    protected void slab(Consumer<FinishedRecipe> finishedRecipeConsumer, Supplier<Block> slab, TagKey<Item> tag) {
        this.slab(finishedRecipeConsumer, slab.get(), tag);
    }

    protected void slab(Consumer<FinishedRecipe> finishedRecipeConsumer, Block slab, TagKey<Item> tag) {
        RecipeBuilder builder = RecipeProvider.m_176704_((ItemLike)slab, (Ingredient)Ingredient.m_204132_(tag));
        builder.m_126132_("has_" + tag.f_203868_().m_135827_(), (CriterionTriggerInstance)RecipeProvider.m_206406_(tag));
        builder.m_176498_(finishedRecipeConsumer);
    }

    @SafeVarargs
    protected final void slab(Consumer<FinishedRecipe> finishedRecipeConsumer, Supplier<Block> slab, Supplier<Block> ... material) {
        this.slab(finishedRecipeConsumer, slab.get(), (Block[])Arrays.stream(material).map(Supplier::get).toArray(Block[]::new));
    }

    protected void slab(Consumer<FinishedRecipe> finishedRecipeConsumer, Block slab, Block ... material) {
        RecipeBuilder builder = RecipeProvider.m_176704_((ItemLike)slab, (Ingredient)Ingredient.m_43929_((ItemLike[])material));
        for (Block block : material) {
            builder.m_126132_("has_" + RecipeProvider.m_176602_((ItemLike)block), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)block));
        }
        builder.m_176498_(finishedRecipeConsumer);
    }

    protected void stairs(Consumer<FinishedRecipe> finishedRecipeConsumer, Supplier<Block> stairs, TagKey<Item> tag) {
        this.stairs(finishedRecipeConsumer, stairs.get(), tag);
    }

    protected void stairs(Consumer<FinishedRecipe> finishedRecipeConsumer, Block stairs, TagKey<Item> tag) {
        this.stairs(finishedRecipeConsumer, true, stairs, tag);
    }

    protected void stairs(Consumer<FinishedRecipe> finishedRecipeConsumer, boolean craft8, Block stairs, TagKey<Item> tag) {
        RecipeBuilder builder = craft8 ? RecipeProvider.betterStairBuilder((ItemLike)stairs, Ingredient.m_204132_(tag)) : RecipeProvider.m_176710_((ItemLike)stairs, (Ingredient)Ingredient.m_204132_(tag));
        builder.m_126132_("has_" + tag.f_203868_().m_135827_(), (CriterionTriggerInstance)RecipeProvider.m_206406_(tag));
        builder.m_176498_(finishedRecipeConsumer);
    }

    @SafeVarargs
    protected final void stairs(Consumer<FinishedRecipe> finishedRecipeConsumer, Supplier<Block> stairs, Supplier<Block> ... material) {
        this.stairs(finishedRecipeConsumer, stairs.get(), (Block[])Arrays.stream(material).map(Supplier::get).toArray(Block[]::new));
    }

    protected void stairs(Consumer<FinishedRecipe> finishedRecipeConsumer, Block stairs, Block ... material) {
        this.stairs(finishedRecipeConsumer, true, stairs, material);
    }

    protected void stairs(Consumer<FinishedRecipe> finishedRecipeConsumer, boolean craft8, Block stairs, Block ... material) {
        RecipeBuilder builder = craft8 ? RecipeProvider.betterStairBuilder((ItemLike)stairs, Ingredient.m_43929_((ItemLike[])material)) : RecipeProvider.m_176710_((ItemLike)stairs, (Ingredient)Ingredient.m_43929_((ItemLike[])material));
        for (Block block : material) {
            builder.m_126132_("has_" + RecipeProvider.m_176602_((ItemLike)block), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)block));
        }
        builder.m_176498_(finishedRecipeConsumer);
    }

    protected static RecipeBuilder betterStairBuilder(ItemLike pStairs, Ingredient pMaterial) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)pStairs, (int)8).m_126124_(Character.valueOf('#'), pMaterial).m_126130_("#  ").m_126130_("## ").m_126130_("###");
    }

    protected void stairsToBlock(Consumer<FinishedRecipe> finishedRecipeConsumer, Block stair, Block block) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)block, (int)3).m_126211_((ItemLike)stair, 4).m_126132_("has_" + RecipeProvider.m_176602_((ItemLike)stair), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)stair)).m_126140_(finishedRecipeConsumer, new ResourceLocation(this.rl(block).m_135827_(), "stairs_to_block/" + this.rl(block).m_135815_()));
    }

    protected void slabsToBlock(Consumer<FinishedRecipe> finishedRecipeConsumer, Block slab, Block block) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)block, (int)1).m_126211_((ItemLike)slab, 2).m_126132_("has_" + RecipeProvider.m_176602_((ItemLike)slab), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)slab)).m_126140_(finishedRecipeConsumer, new ResourceLocation(this.rl(block).m_135827_(), "slabs_to_block/" + this.rl(block).m_135815_()));
    }

    protected void sword(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike sword) {
        this.sword(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), sword);
    }

    protected void sword(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, ItemLike sword) {
        this.sword(finishedRecipeConsumer, Ingredient.m_204132_(material), sword);
    }

    protected void sword(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, ItemLike sword) {
        this.sword(finishedRecipeConsumer, material, Ingredient.m_204132_((TagKey)Tags.Items.RODS_WOODEN), sword);
    }

    protected void sword(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike stick, ItemLike sword) {
        this.sword(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{stick}), sword);
    }

    protected void sword(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, TagKey<Item> stick, ItemLike sword) {
        this.sword(finishedRecipeConsumer, Ingredient.m_204132_(material), Ingredient.m_204132_(stick), sword);
    }

    protected void sword(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, Ingredient stick, ItemLike sword) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)sword).m_126130_("X").m_126130_("X").m_126130_("S").m_126124_(Character.valueOf('X'), material).m_126124_(Character.valueOf('S'), stick);
        this.saveWithAutoUnlock(finishedRecipeConsumer, builder, material);
    }

    protected void axe(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike axe) {
        this.axe(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), axe);
    }

    protected void axe(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, ItemLike axe) {
        this.axe(finishedRecipeConsumer, Ingredient.m_204132_(material), axe);
    }

    protected void axe(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, ItemLike axe) {
        this.axe(finishedRecipeConsumer, material, Ingredient.m_204132_((TagKey)Tags.Items.RODS_WOODEN), axe);
    }

    protected void axe(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike stick, ItemLike axe) {
        this.axe(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{stick}), axe);
    }

    protected void axe(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, TagKey<Item> stick, ItemLike axe) {
        this.axe(finishedRecipeConsumer, Ingredient.m_204132_(material), Ingredient.m_204132_(stick), axe);
    }

    protected void axe(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, Ingredient stick, ItemLike axe) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)axe).m_126130_("XX").m_126130_("XS").m_126130_(" S").m_126124_(Character.valueOf('X'), material).m_126124_(Character.valueOf('S'), stick);
        this.saveWithAutoUnlock(finishedRecipeConsumer, builder, material);
    }

    protected void hoe(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike hoe) {
        this.hoe(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), hoe);
    }

    protected void hoe(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, ItemLike hoe) {
        this.hoe(finishedRecipeConsumer, Ingredient.m_204132_(material), hoe);
    }

    protected void hoe(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, ItemLike hoe) {
        this.hoe(finishedRecipeConsumer, material, Ingredient.m_204132_((TagKey)Tags.Items.RODS_WOODEN), hoe);
    }

    protected void hoe(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike stick, ItemLike hoe) {
        this.hoe(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{stick}), hoe);
    }

    protected void hoe(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, TagKey<Item> stick, ItemLike hoe) {
        this.hoe(finishedRecipeConsumer, Ingredient.m_204132_(material), Ingredient.m_204132_(stick), hoe);
    }

    protected void hoe(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, Ingredient stick, ItemLike hoe) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)hoe).m_126130_("XX").m_126130_(" S").m_126130_(" S").m_126124_(Character.valueOf('X'), material).m_126124_(Character.valueOf('S'), stick);
        this.saveWithAutoUnlock(finishedRecipeConsumer, builder, material);
    }

    protected void pickaxe(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike pickaxe) {
        this.pickaxe(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), pickaxe);
    }

    protected void pickaxe(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, ItemLike pickaxe) {
        this.pickaxe(finishedRecipeConsumer, Ingredient.m_204132_(material), pickaxe);
    }

    protected void pickaxe(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, ItemLike pickaxe) {
        this.pickaxe(finishedRecipeConsumer, material, Ingredient.m_204132_((TagKey)Tags.Items.RODS_WOODEN), pickaxe);
    }

    protected void pickaxe(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike stick, ItemLike pickaxe) {
        this.pickaxe(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{stick}), pickaxe);
    }

    protected void pickaxe(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, TagKey<Item> stick, ItemLike pickaxe) {
        this.pickaxe(finishedRecipeConsumer, Ingredient.m_204132_(material), Ingredient.m_204132_(stick), pickaxe);
    }

    protected void pickaxe(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, Ingredient stick, ItemLike pickaxe) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)pickaxe).m_126130_("XXX").m_126130_(" S ").m_126130_(" S ").m_126124_(Character.valueOf('X'), material).m_126124_(Character.valueOf('S'), stick);
        this.saveWithAutoUnlock(finishedRecipeConsumer, builder, material);
    }

    protected void shovel(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike shovel) {
        this.shovel(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), shovel);
    }

    protected void shovel(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, ItemLike shovel) {
        this.shovel(finishedRecipeConsumer, Ingredient.m_204132_(material), shovel);
    }

    protected void shovel(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, ItemLike shovel) {
        this.shovel(finishedRecipeConsumer, material, Ingredient.m_204132_((TagKey)Tags.Items.RODS_WOODEN), shovel);
    }

    protected void shovel(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike stick, ItemLike shovel) {
        this.shovel(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{stick}), shovel);
    }

    protected void shovel(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, TagKey<Item> stick, ItemLike shovel) {
        this.shovel(finishedRecipeConsumer, Ingredient.m_204132_(material), Ingredient.m_204132_(stick), shovel);
    }

    protected void shovel(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, Ingredient stick, ItemLike shovel) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)shovel).m_126130_("X").m_126130_("S").m_126130_("S").m_126124_(Character.valueOf('X'), material).m_126124_(Character.valueOf('S'), stick);
        this.saveWithAutoUnlock(finishedRecipeConsumer, builder, material);
    }

    protected void tools(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike axe, ItemLike hoe, ItemLike pickaxe, ItemLike shovel, ItemLike sword) {
        this.tools(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), axe, hoe, pickaxe, shovel, sword);
    }

    protected void tools(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, ItemLike axe, ItemLike hoe, ItemLike pickaxe, ItemLike shovel, ItemLike sword) {
        this.tools(finishedRecipeConsumer, Ingredient.m_204132_(material), axe, hoe, pickaxe, shovel, sword);
    }

    protected void tools(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, ItemLike axe, ItemLike hoe, ItemLike pickaxe, ItemLike shovel, ItemLike sword) {
        this.tools(finishedRecipeConsumer, material, Ingredient.m_204132_((TagKey)Tags.Items.RODS_WOODEN), axe, hoe, pickaxe, shovel, sword);
    }

    protected void tools(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike stick, ItemLike axe, ItemLike hoe, ItemLike pickaxe, ItemLike shovel, ItemLike sword) {
        this.tools(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{stick}), axe, hoe, pickaxe, shovel, sword);
    }

    protected void tools(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, TagKey<Item> stick, ItemLike axe, ItemLike hoe, ItemLike pickaxe, ItemLike shovel, ItemLike sword) {
        this.tools(finishedRecipeConsumer, Ingredient.m_204132_(material), Ingredient.m_204132_(stick), axe, hoe, pickaxe, shovel, sword);
    }

    protected void tools(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, Ingredient stick, ItemLike axe, ItemLike hoe, ItemLike pickaxe, ItemLike shovel, ItemLike sword) {
        this.axe(finishedRecipeConsumer, material, stick, axe);
        this.hoe(finishedRecipeConsumer, material, stick, hoe);
        this.pickaxe(finishedRecipeConsumer, material, stick, pickaxe);
        this.shovel(finishedRecipeConsumer, material, stick, shovel);
        this.sword(finishedRecipeConsumer, material, stick, sword);
    }

    protected void saveWithAutoUnlock(Consumer<FinishedRecipe> finishedRecipeConsumer, ShapedRecipeBuilder builder, Ingredient material) {
        this.saveWithAutoUnlock(finishedRecipeConsumer, builder, material, "");
    }

    protected void saveWithAutoUnlock(Consumer<FinishedRecipe> finishedRecipeConsumer, ShapedRecipeBuilder builder, Ingredient material, String filePath) {
        if (material.m_43908_().length > 1) {
            ((ShapedRecipeBuilderAccessor)builder).getAdvancement().m_138360_(RequirementsStrategy.f_15979_);
        }
        for (ItemStack stack : material.m_43908_()) {
            builder.m_126132_(RecipeProvider.m_176602_((ItemLike)stack.m_41720_()), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)stack.m_41720_()));
        }
        ResourceLocation recipeResourceLocation = RecipeBuilder.m_176493_((ItemLike)builder.m_142372_());
        builder.m_126140_(finishedRecipeConsumer, new ResourceLocation(recipeResourceLocation.m_135827_(), filePath + recipeResourceLocation.m_135815_()));
    }

    protected String getHasName(ItemStack stack) {
        return RecipeProvider.m_176602_((ItemLike)stack.m_41720_());
    }

    protected void nineStorage(Consumer<FinishedRecipe> finishedRecipeConsumer, Supplier<ItemLike> material, ItemLike packedMaterial) {
        this.nineStorage(finishedRecipeConsumer, material.get(), packedMaterial);
    }

    protected void nineStorage(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, Supplier<ItemLike> packedMaterial) {
        this.nineStorage(finishedRecipeConsumer, material, packedMaterial.get());
    }

    protected void nineStorage(Consumer<FinishedRecipe> finishedRecipeConsumer, Supplier<ItemLike> material, Supplier<ItemLike> packedMaterial) {
        this.nineStorage(finishedRecipeConsumer, material.get(), packedMaterial.get());
    }

    protected void nineStorage(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike packedMaterial) {
        this.nineStorage(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), packedMaterial);
    }

    protected void nineStorage(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, ItemLike packedMaterial) {
        this.nineStorage(finishedRecipeConsumer, Ingredient.m_204132_(material), packedMaterial);
    }

    protected void nineStorage(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, ItemLike packedMaterial) {
        if (material.m_43908_().length == 0) {
            throw new IllegalStateException("No Item in material ingredient of recipe: " + this.rl(packedMaterial));
        }
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)packedMaterial).m_126130_("XXX").m_126130_("XXX").m_126130_("XXX").m_126124_(Character.valueOf('X'), material);
        this.saveWithAutoUnlock(finishedRecipeConsumer, builder, material, "storage/pack/");
    }

    protected void helmet(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike helmet) {
        this.helmet(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), helmet);
    }

    protected void helmet(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, ItemLike helmet) {
        this.helmet(finishedRecipeConsumer, Ingredient.m_204132_(material), helmet);
    }

    protected void helmet(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, ItemLike helmet) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)helmet).m_126130_("XXX").m_126130_("X X").m_126124_(Character.valueOf('X'), material);
        this.saveWithAutoUnlock(finishedRecipeConsumer, builder, material);
    }

    protected void chestplate(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike chestplate) {
        this.chestplate(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), chestplate);
    }

    protected void chestplate(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, ItemLike chestplate) {
        this.chestplate(finishedRecipeConsumer, Ingredient.m_204132_(material), chestplate);
    }

    protected void chestplate(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, ItemLike chestplate) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)chestplate).m_126130_("X X").m_126130_("XXX").m_126130_("XXX").m_126124_(Character.valueOf('X'), material);
        this.saveWithAutoUnlock(finishedRecipeConsumer, builder, material);
    }

    protected void leggings(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike leggings) {
        this.leggings(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), leggings);
    }

    protected void leggings(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, ItemLike leggings) {
        this.leggings(finishedRecipeConsumer, Ingredient.m_204132_(material), leggings);
    }

    protected void leggings(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, ItemLike leggings) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)leggings).m_126130_("XXX").m_126130_("X X").m_126130_("X X").m_126124_(Character.valueOf('X'), material);
        this.saveWithAutoUnlock(finishedRecipeConsumer, builder, material);
    }

    protected void boots(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike boots) {
        this.boots(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), boots);
    }

    protected void boots(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, ItemLike boots) {
        this.boots(finishedRecipeConsumer, Ingredient.m_204132_(material), boots);
    }

    protected void boots(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, ItemLike boots) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)boots).m_126130_("X X").m_126130_("X X").m_126124_(Character.valueOf('X'), material);
        this.saveWithAutoUnlock(finishedRecipeConsumer, builder, material);
    }

    protected void armour(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike helmet, ItemLike chestplate, ItemLike leggings, ItemLike boots) {
        this.armour(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), helmet, chestplate, leggings, boots);
    }

    protected void armour(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, ItemLike helmet, ItemLike chestplate, ItemLike leggings, ItemLike boots) {
        this.armour(finishedRecipeConsumer, Ingredient.m_204132_(material), helmet, chestplate, leggings, boots);
    }

    protected void armour(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, ItemLike helmet, ItemLike chestplate, ItemLike leggings, ItemLike boots) {
        this.helmet(finishedRecipeConsumer, material, helmet);
        this.chestplate(finishedRecipeConsumer, material, chestplate);
        this.leggings(finishedRecipeConsumer, material, leggings);
        this.boots(finishedRecipeConsumer, material, boots);
    }

    protected void armor(Consumer<FinishedRecipe> finishedRecipeConsumer, ItemLike material, ItemLike helmet, ItemLike chestplate, ItemLike leggings, ItemLike boots) {
        this.armour(finishedRecipeConsumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), helmet, chestplate, leggings, boots);
    }

    protected void armor(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> material, ItemLike helmet, ItemLike chestplate, ItemLike leggings, ItemLike boots) {
        this.armour(finishedRecipeConsumer, Ingredient.m_204132_(material), helmet, chestplate, leggings, boots);
    }

    protected void armor(Consumer<FinishedRecipe> finishedRecipeConsumer, Ingredient material, ItemLike helmet, ItemLike chestplate, ItemLike leggings, ItemLike boots) {
        this.armour(finishedRecipeConsumer, material, helmet, chestplate, leggings, boots);
    }

    protected void planksFromLogs(Consumer<FinishedRecipe> pFinishedRecipeConsumer, Supplier<ItemLike> pPlanks, TagKey<Item> pLogs) {
        RecipeProvider.m_206412_(pFinishedRecipeConsumer, (ItemLike)pPlanks.get(), pLogs);
    }
}

