/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.data.gen;

import com.github.manasmods.manascore.api.data.gen.annotation.GenerateItemModels;
import com.github.manasmods.manascore.api.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;

@ApiStatus.AvailableSince(value="1.0.0.0")
public abstract class ItemModelProvider
extends net.minecraftforge.client.model.generators.ItemModelProvider {
    private static final Logger log = LogManager.getLogger(ItemModelProvider.class);
    private static final Type GEN_MODELS = Type.getType(GenerateItemModels.class);

    public ItemModelProvider(GatherDataEvent gatherDataEvent, String modId) {
        super(gatherDataEvent.getGenerator(), modId, gatherDataEvent.getExistingFileHelper());
    }

    @ApiStatus.OverrideOnly
    protected abstract void generate();

    @ApiStatus.NonExtendable
    protected final void registerModels() {
        this.generate();
        ArrayList<ModFileScanData.AnnotationData> annotations = new ArrayList<ModFileScanData.AnnotationData>();
        ModList.get().forEachModFile(modFile -> modFile.getScanResult().getAnnotations().stream().filter(annotationData -> GEN_MODELS.equals((Object)annotationData.annotationType())).forEach(annotations::add));
        this.generateAnnotationModels(annotations);
    }

    @ApiStatus.NonExtendable
    private void generateAnnotationModels(List<ModFileScanData.AnnotationData> annotations) {
        annotations.forEach(annotationData -> {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(annotationData.clazz().getClassName());
            }
            catch (ClassNotFoundException e) {
                log.error("Could not load class " + annotationData.clazz().getClassName());
                log.throwing((Throwable)e);
            }
            if (clazz == null) {
                return;
            }
            List<Field> itemRegistryObjectFieldList = Arrays.stream(clazz.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getType().equals(RegistryObject.class)).filter(field -> {
                ParameterizedType registryObjectType = null;
                try {
                    registryObjectType = (ParameterizedType)field.getGenericType();
                }
                catch (ClassCastException e) {
                    log.error("Could not load generic type of field " + field.getName() + " in " + annotationData.clazz().getClassName());
                    log.throwing((Throwable)e);
                }
                if (registryObjectType == null) {
                    return false;
                }
                Class registryObjectClass = null;
                try {
                    registryObjectClass = (Class)registryObjectType.getActualTypeArguments()[0];
                }
                catch (ClassCastException e) {
                    log.error("Could not load generic type of field " + field.getName() + " in " + annotationData.clazz().getClassName() + ".");
                    log.throwing((Throwable)e);
                }
                if (registryObjectClass == null) {
                    return false;
                }
                return Item.class.isAssignableFrom(registryObjectClass);
            }).toList();
            this.generateSingleTextureModels((ModFileScanData.AnnotationData)annotationData, itemRegistryObjectFieldList);
            this.generateSingleHandheldTextureModels((ModFileScanData.AnnotationData)annotationData, itemRegistryObjectFieldList);
        });
    }

    @ApiStatus.NonExtendable
    private void generateSingleTextureModels(ModFileScanData.AnnotationData annotationData, List<Field> itemRegistryObjectFieldList) {
        for (Field registryObjectField : itemRegistryObjectFieldList) {
            RegistryObject<Item> registryObject;
            if (!registryObjectField.isAnnotationPresent(GenerateItemModels.SingleTextureModel.class) || (registryObject = ReflectionUtils.getRegistryObjectFromField(annotationData, registryObjectField, Item.class)) == null) continue;
            GenerateItemModels.SingleTextureModel annotation = registryObjectField.getAnnotation(GenerateItemModels.SingleTextureModel.class);
            if (annotation.value().isEmpty() || annotation.value().isBlank()) {
                log.debug("Generating item model for registry object {}", (Object)registryObject.getId());
                this.singleTexture((Item)registryObject.get());
                continue;
            }
            ResourceLocation itemId = ResourceLocation.m_135820_((String)annotation.value());
            Item textureItem = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (textureItem == null) {
                log.error("Could not find texture item {} for item {}", (Object)itemId, (Object)registryObject.getId());
                continue;
            }
            log.debug("Generating item model for registry object {} with texture of {}", (Object)registryObject.getId(), (Object)itemId);
            this.singleTexture((Item)registryObject.get(), textureItem);
        }
    }

    @ApiStatus.NonExtendable
    private void generateSingleHandheldTextureModels(ModFileScanData.AnnotationData annotationData, List<Field> itemRegistryObjectFieldList) {
        for (Field registryObjectField : itemRegistryObjectFieldList) {
            RegistryObject<Item> registryObject;
            if (!registryObjectField.isAnnotationPresent(GenerateItemModels.SingleHandheldTextureModel.class) || (registryObject = ReflectionUtils.getRegistryObjectFromField(annotationData, registryObjectField, Item.class)) == null) continue;
            GenerateItemModels.SingleHandheldTextureModel annotation = registryObjectField.getAnnotation(GenerateItemModels.SingleHandheldTextureModel.class);
            if (annotation.value().isEmpty() || annotation.value().isBlank()) {
                log.debug("Generating item model for registry object {}", (Object)registryObject.getId());
                this.handheldSingleTexture((Item)registryObject.get());
                continue;
            }
            ResourceLocation itemId = ResourceLocation.m_135820_((String)annotation.value());
            Item textureItem = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (textureItem == null) {
                log.error("Could not find texture item {} for item {}", (Object)itemId, (Object)registryObject.getId());
                continue;
            }
            log.debug("Generating item model for registry object {} with texture of {}", (Object)registryObject.getId(), (Object)itemId);
            this.handheldSingleTexture((Item)registryObject.get(), textureItem);
        }
    }

    @ApiStatus.AvailableSince(value="2.0.0.0")
    @ApiStatus.NonExtendable
    protected final ResourceLocation rl(Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item));
    }

    @ApiStatus.AvailableSince(value="2.0.0.0")
    @ApiStatus.NonExtendable
    protected final String name(Item item) {
        return this.rl(item).m_135815_();
    }

    protected void singleTexture(Item item) {
        this.singleTexture(item, item);
    }

    protected void singleTexture(Item item, Item textureItem) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.name(item))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/generated")))).texture("layer0", new ResourceLocation(this.rl(textureItem).m_135827_(), "item/" + this.name(textureItem)));
    }

    protected void handheldSingleTexture(Item item) {
        this.handheldSingleTexture(item, item);
    }

    protected void handheldSingleTexture(Item item, Item textureItem) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.name(item))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/handheld")))).texture("layer0", new ResourceLocation(this.rl(textureItem).m_135827_(), "item/" + this.name(textureItem)));
    }
}

