/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.data.gen;

import com.github.manasmods.manascore.api.data.gen.annotation.GenerateEntityLoot;
import com.github.manasmods.manascore.api.util.ReflectionUtils;
import com.github.manasmods.manascore.api.util.StreamUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;

public abstract class EntityLoot
extends net.minecraft.data.loot.EntityLoot {
    private static final Logger log = LogManager.getLogger(EntityLoot.class);
    private static final Type GEN_ANNOTATION = Type.getType(GenerateEntityLoot.class);

    @ApiStatus.NonExtendable
    protected final void addTables() {
        this.loadTables();
        ArrayList<ModFileScanData.AnnotationData> annotations = new ArrayList<ModFileScanData.AnnotationData>();
        ModList.get().forEachModFile(modFile -> modFile.getScanResult().getAnnotations().stream().filter(annotationData -> GEN_ANNOTATION.equals((Object)annotationData.annotationType())).forEach(annotations::add));
        this.generateAnnotationLootTables(annotations);
    }

    @ApiStatus.NonExtendable
    private void generateAnnotationLootTables(List<ModFileScanData.AnnotationData> annotations) {
        annotations.forEach(annotationData -> {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(annotationData.clazz().getClassName());
            }
            catch (ClassNotFoundException e) {
                log.error("Could not load class " + annotationData.clazz().getClassName());
                log.throwing((Throwable)e);
            }
            if (clazz == null) {
                return;
            }
            List<Field> entityRegistryObjectFieldList = Arrays.stream(clazz.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getType().equals(RegistryObject.class)).filter(field -> {
                ParameterizedType registryObjectType = null;
                try {
                    registryObjectType = (ParameterizedType)field.getGenericType();
                }
                catch (ClassCastException e) {
                    log.error("Could not load generic type of field " + field.getName() + " in " + annotationData.clazz().getClassName());
                    log.throwing((Throwable)e);
                }
                if (registryObjectType == null) {
                    return false;
                }
                Class registryObjectClass = null;
                try {
                    registryObjectClass = (Class)registryObjectType.getActualTypeArguments()[0];
                }
                catch (ClassCastException e) {
                    log.error("Could not load generic type of field " + field.getName() + " in " + annotationData.clazz().getClassName() + ".");
                    log.throwing((Throwable)e);
                }
                if (registryObjectClass == null) {
                    return false;
                }
                return EntityType.class.isAssignableFrom(registryObjectClass);
            }).toList();
            this.generateEmptyLootTables((ModFileScanData.AnnotationData)annotationData, entityRegistryObjectFieldList);
        });
    }

    @ApiStatus.NonExtendable
    private void generateEmptyLootTables(ModFileScanData.AnnotationData annotationData, List<Field> entityRegistryObjectFieldList) {
        for (Field registryObjectField : entityRegistryObjectFieldList) {
            RegistryObject<EntityType> registryObject;
            if (!registryObjectField.isAnnotationPresent(GenerateEntityLoot.EmptyLootTable.class) || (registryObject = ReflectionUtils.getRegistryObjectFromField(annotationData, registryObjectField, EntityType.class)) == null) continue;
            log.debug("Generating block loot for registry object {}", (Object)registryObject.getId());
            this.m_124371_((EntityType)registryObject.get(), LootTable.m_79147_());
        }
    }

    protected abstract void loadTables();

    protected Iterable<EntityType<?>> getKnownEntities() {
        return ModList.get().getAllScanData().stream().flatMap(modFileScanData -> modFileScanData.getAnnotations().stream()).filter(annotationData -> GEN_ANNOTATION.equals((Object)annotationData.annotationType())).flatMap(annotationData -> {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(annotationData.clazz().getClassName());
            }
            catch (ClassNotFoundException e) {
                log.error("Could not load class " + annotationData.clazz().getClassName());
                log.throwing((Throwable)e);
            }
            if (clazz == null) {
                return Stream.of(new EntityType[0]);
            }
            return Arrays.stream(clazz.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getType().equals(DeferredRegister.class)).filter(field -> {
                ParameterizedType registryObjectType = null;
                try {
                    registryObjectType = (ParameterizedType)field.getGenericType();
                }
                catch (ClassCastException e) {
                    log.error("Could not load generic type of field " + field.getName() + " in " + annotationData.clazz().getClassName());
                    log.throwing((Throwable)e);
                }
                if (registryObjectType == null) {
                    return false;
                }
                Class registryObjectClass = null;
                try {
                    registryObjectClass = (Class)registryObjectType.getActualTypeArguments()[0];
                }
                catch (ClassCastException e) {
                    log.error("Could not load generic type of field " + field.getName() + " in " + annotationData.clazz().getClassName() + ".");
                    log.throwing((Throwable)e);
                }
                if (registryObjectClass == null) {
                    return false;
                }
                return EntityType.class.isAssignableFrom(registryObjectClass);
            }).filter(field -> field.isAnnotationPresent(GenerateEntityLoot.WithLootTables.class)).map(field -> ReflectionUtils.getDeferredRegisterFromField(annotationData, field, EntityType.class)).filter(Objects::nonNull).flatMap(blockDeferredRegister -> blockDeferredRegister.getEntries().stream()).filter(RegistryObject::isPresent).filter(StreamUtils.distinctBy(entityTypeRegistryObject -> entityTypeRegistryObject)).map(RegistryObject::get);
        }).toList();
    }
}

