/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.data.gen;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0.0")
public abstract class CustomDataProvider
implements DataProvider {
    private static final Logger log = LogManager.getLogger(CustomDataProvider.class);
    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2.1.0.0")
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final String outputPath;
    private final DataGenerator generator;

    public CustomDataProvider(String path, DataGenerator generator) {
        this.outputPath = path;
        this.generator = generator;
    }

    @ApiStatus.OverrideOnly
    protected abstract void run(BiConsumer<ResourceLocation, Supplier<JsonElement>> var1);

    public void m_213708_(CachedOutput pOutput) {
        HashMap map = Maps.newHashMap();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer = (location, jsonElementSupplier) -> {
            Supplier supplier = map.put(location, jsonElementSupplier);
            if (supplier != null) {
                throw new IllegalStateException(String.format("Duplicate %s for %s", this.m_6055_(), location));
            }
        };
        this.run(consumer);
        map.forEach((location, jsonElementSupplier) -> {
            Path path = this.generator.m_123916_().resolve("data").resolve(location.m_135827_()).resolve(this.outputPath).resolve(location.m_135815_() + ".json");
            try {
                DataProvider.m_236072_((CachedOutput)pOutput, (JsonElement)((JsonElement)jsonElementSupplier.get()), (Path)path);
            }
            catch (IOException e) {
                log.error("Couldn't save {}", (Object)path, (Object)e);
            }
        });
    }
}

