/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.data.gen;

import com.github.manasmods.manascore.api.data.gen.RenderType;
import com.github.manasmods.manascore.api.data.gen.annotation.GenerateBlockModels;
import com.github.manasmods.manascore.api.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;

@ApiStatus.AvailableSince(value="1.0.0.0")
public abstract class BlockStateProvider
extends net.minecraftforge.client.model.generators.BlockStateProvider {
    private static final Logger log = LogManager.getLogger(BlockStateProvider.class);
    private static final Type GEN_ANNOTATION = Type.getType(GenerateBlockModels.class);

    public BlockStateProvider(GatherDataEvent gatherDataEvent, String modId) {
        super(gatherDataEvent.getGenerator(), modId, gatherDataEvent.getExistingFileHelper());
    }

    @ApiStatus.OverrideOnly
    protected abstract void generate();

    @ApiStatus.NonExtendable
    protected final void registerStatesAndModels() {
        this.generate();
        ArrayList<ModFileScanData.AnnotationData> annotations = new ArrayList<ModFileScanData.AnnotationData>();
        ModList.get().forEachModFile(modFile -> modFile.getScanResult().getAnnotations().stream().filter(annotationData -> GEN_ANNOTATION.equals((Object)annotationData.annotationType())).forEach(annotations::add));
        this.generateAnnotationModels(annotations);
    }

    @ApiStatus.NonExtendable
    private void generateAnnotationModels(List<ModFileScanData.AnnotationData> annotations) {
        annotations.forEach(annotationData -> {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(annotationData.clazz().getClassName());
            }
            catch (ClassNotFoundException e) {
                log.error("Could not load class " + annotationData.clazz().getClassName());
                log.throwing((Throwable)e);
            }
            if (clazz == null) {
                return;
            }
            List<Field> blockRegistryObjectFieldList = Arrays.stream(clazz.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getType().equals(RegistryObject.class)).filter(field -> {
                ParameterizedType registryObjectType = null;
                try {
                    registryObjectType = (ParameterizedType)field.getGenericType();
                }
                catch (ClassCastException e) {
                    log.error("Could not load generic type of field " + field.getName() + " in " + annotationData.clazz().getClassName());
                    log.throwing((Throwable)e);
                }
                if (registryObjectType == null) {
                    return false;
                }
                Class registryObjectClass = null;
                try {
                    registryObjectClass = (Class)registryObjectType.getActualTypeArguments()[0];
                }
                catch (ClassCastException e) {
                    log.error("Could not load generic type of field " + field.getName() + " in " + annotationData.clazz().getClassName() + ".");
                    log.throwing((Throwable)e);
                }
                if (registryObjectClass == null) {
                    return false;
                }
                return Block.class.isAssignableFrom(registryObjectClass);
            }).toList();
            this.generateCubeAllModels((ModFileScanData.AnnotationData)annotationData, blockRegistryObjectFieldList);
            this.generatePillarModels((ModFileScanData.AnnotationData)annotationData, blockRegistryObjectFieldList);
            this.generateStairModels((ModFileScanData.AnnotationData)annotationData, blockRegistryObjectFieldList);
            this.generateSlabModels((ModFileScanData.AnnotationData)annotationData, blockRegistryObjectFieldList);
        });
    }

    @ApiStatus.NonExtendable
    private void generateCubeAllModels(ModFileScanData.AnnotationData annotationData, List<Field> blockRegistryObjectFieldList) {
        for (Field registryObjectField : blockRegistryObjectFieldList) {
            RegistryObject<Block> registryObject;
            if (!registryObjectField.isAnnotationPresent(GenerateBlockModels.CubeAllModel.class) || (registryObject = ReflectionUtils.getRegistryObjectFromField(annotationData, registryObjectField, Block.class)) == null) continue;
            GenerateBlockModels.CubeAllModel annotation = registryObjectField.getAnnotation(GenerateBlockModels.CubeAllModel.class);
            if (annotation.value().isEmpty() || annotation.value().isBlank()) {
                log.debug("Generating block model for registry object {}", (Object)registryObject.getId());
                this.defaultBlock((Block)registryObject.get(), annotation.renderType());
                continue;
            }
            ResourceLocation itemId = ResourceLocation.m_135820_((String)annotation.value());
            Block textureBlock = (Block)ForgeRegistries.BLOCKS.getValue(itemId);
            if (textureBlock == null) {
                log.error("Could not find texture block {} for block {}", (Object)itemId, (Object)registryObject.getId());
                continue;
            }
            log.debug("Generating block model for registry object {} with texture of {}", (Object)registryObject.getId(), (Object)itemId);
            this.defaultBlock((Block)registryObject.get(), textureBlock, annotation.renderType());
        }
    }

    @ApiStatus.NonExtendable
    private void generatePillarModels(ModFileScanData.AnnotationData annotationData, List<Field> blockRegistryObjectFieldList) {
        for (Field registryObjectField : blockRegistryObjectFieldList) {
            RegistryObject<Block> registryObject;
            if (!registryObjectField.isAnnotationPresent(GenerateBlockModels.PillarModel.class) || (registryObject = ReflectionUtils.getRegistryObjectFromField(annotationData, registryObjectField, Block.class)) == null) continue;
            log.debug("Generating block model for registry object {}", (Object)registryObject.getId());
            this.pillar((Block)registryObject.get());
        }
    }

    @ApiStatus.NonExtendable
    private void generateStairModels(ModFileScanData.AnnotationData annotationData, List<Field> blockRegistryObjectFieldList) {
        for (Field registryObjectField : blockRegistryObjectFieldList) {
            RegistryObject<Block> registryObject;
            if (!registryObjectField.isAnnotationPresent(GenerateBlockModels.StairModel.class) || (registryObject = ReflectionUtils.getRegistryObjectFromField(annotationData, registryObjectField, Block.class)) == null) continue;
            GenerateBlockModels.StairModel annotation = registryObjectField.getAnnotation(GenerateBlockModels.StairModel.class);
            ResourceLocation itemId = ResourceLocation.m_135820_((String)annotation.value());
            Block textureBlock = (Block)ForgeRegistries.BLOCKS.getValue(itemId);
            if (textureBlock == null) {
                log.error("Could not find texture block {} for block {}", (Object)itemId, (Object)registryObject.getId());
                continue;
            }
            log.debug("Generating block model for registry object {} with texture of {}", (Object)registryObject.getId(), (Object)itemId);
            this.stairs((Block)registryObject.get(), textureBlock);
        }
    }

    @ApiStatus.NonExtendable
    private void generateSlabModels(ModFileScanData.AnnotationData annotationData, List<Field> blockRegistryObjectFieldList) {
        for (Field registryObjectField : blockRegistryObjectFieldList) {
            RegistryObject<Block> registryObject;
            if (!registryObjectField.isAnnotationPresent(GenerateBlockModels.SlabModel.class) || (registryObject = ReflectionUtils.getRegistryObjectFromField(annotationData, registryObjectField, Block.class)) == null) continue;
            GenerateBlockModels.SlabModel annotation = registryObjectField.getAnnotation(GenerateBlockModels.SlabModel.class);
            ResourceLocation itemId = ResourceLocation.m_135820_((String)annotation.value());
            Block textureBlock = (Block)ForgeRegistries.BLOCKS.getValue(itemId);
            if (textureBlock == null) {
                log.error("Could not find texture block {} for block {}", (Object)itemId, (Object)registryObject.getId());
                continue;
            }
            log.debug("Generating block model for registry object {} with texture of {}", (Object)registryObject.getId(), (Object)itemId);
            this.slab((Block)registryObject.get(), textureBlock);
        }
    }

    @ApiStatus.AvailableSince(value="2.0.0.0")
    @ApiStatus.NonExtendable
    protected final ResourceLocation rl(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    @ApiStatus.NonExtendable
    protected final String name(Block block) {
        return this.rl(block).m_135815_();
    }

    protected void defaultBlock(Block block) {
        this.defaultBlock(block, block);
    }

    protected void defaultBlock(Block block, RenderType renderType) {
        this.defaultBlock(block, block, renderType);
    }

    protected void defaultBlock(Block block, Block textureBlock) {
        this.defaultBlock(block, textureBlock, RenderType.DEFAULT);
    }

    protected void defaultBlock(Block block, Block textureBlock, RenderType renderType) {
        this.getVariantBuilder(block).forAllStates(state -> {
            if (RenderType.DEFAULT.equals((Object)renderType)) {
                return ConfiguredModel.builder().modelFile(this.cubeAll(textureBlock)).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cubeAll(this.name(textureBlock), this.blockTexture(textureBlock))).renderType(renderType.getId())).build();
        });
        ((ItemModelBuilder)this.itemModels().getBuilder(Objects.requireNonNull(this.rl(block)).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name(block))));
    }

    protected void stairs(Block stairBlock, Block textureBlock) {
        if (!(stairBlock instanceof StairBlock)) {
            throw new IllegalArgumentException(Objects.requireNonNull(this.rl(stairBlock)) + " is not a instance of StairBlock.");
        }
        StairBlock block = (StairBlock)stairBlock;
        this.stairsBlock(block, new ResourceLocation(Objects.requireNonNull(this.rl(textureBlock)).m_135827_(), "block/" + this.name(textureBlock)));
        ((ItemModelBuilder)this.itemModels().getBuilder(Objects.requireNonNull(this.rl((Block)block)).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name((Block)block))));
    }

    protected void stairs(Block stairBlock, ResourceLocation top, ResourceLocation bottom, ResourceLocation side, ResourceLocation overlay) {
        if (!(stairBlock instanceof StairBlock)) {
            throw new IllegalArgumentException(Objects.requireNonNull(this.rl(stairBlock)) + " is not a instance of StairBlock.");
        }
        StairBlock block = (StairBlock)stairBlock;
        String baseName = this.rl((Block)block).toString();
        BlockModelBuilder stairs = this.overlayStair(baseName, top, bottom, side, overlay);
        BlockModelBuilder stairsInner = this.overlayInnerStair(baseName + "_inner", top, bottom, side, overlay);
        BlockModelBuilder stairsOuter = this.overlayOuterStair(baseName + "_outer", top, bottom, side, overlay);
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> BlockStateProvider.lambda$stairs$7((ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter, arg_0), new Property[]{StairBlock.f_56844_});
        ((ItemModelBuilder)this.itemModels().getBuilder(this.name((Block)block))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name((Block)block))));
    }

    protected void sidedStairs(Block stairBlock, ResourceLocation top, ResourceLocation bottom, ResourceLocation side) {
        if (!(stairBlock instanceof StairBlock)) {
            throw new IllegalArgumentException(Objects.requireNonNull(this.rl(stairBlock)) + " is not a instance of StairBlock.");
        }
        StairBlock block = (StairBlock)stairBlock;
        String baseName = this.rl((Block)block).toString();
        BlockModelBuilder stairs = this.grassLikeStair(baseName, top, bottom, side);
        BlockModelBuilder stairsInner = this.grassLikeInnerStair(baseName + "_inner", top, bottom, side);
        BlockModelBuilder stairsOuter = this.grassLikeOuterStair(baseName + "_outer", top, bottom, side);
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> BlockStateProvider.lambda$sidedStairs$8((ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter, arg_0), new Property[]{StairBlock.f_56844_});
        ((ItemModelBuilder)this.itemModels().getBuilder(this.name((Block)block))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name((Block)block))));
    }

    protected void stairs(Block stairBlock, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        if (!(stairBlock instanceof StairBlock)) {
            throw new IllegalArgumentException(Objects.requireNonNull(this.rl(stairBlock)) + " is not a instance of StairBlock.");
        }
        StairBlock block = (StairBlock)stairBlock;
        this.stairsBlock(block, side, bottom, top);
        ((ItemModelBuilder)this.itemModels().getBuilder(Objects.requireNonNull(this.rl((Block)block)).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name((Block)block))));
    }

    protected void stairs(Block stairBlock, ResourceLocation side, ResourceLocation top) {
        this.stairs(stairBlock, side, top, top);
    }

    protected void slab(Block slabBlock, Block textureBlock) {
        if (!(slabBlock instanceof SlabBlock)) {
            throw new IllegalArgumentException(Objects.requireNonNull(this.rl(slabBlock)) + " is not a instance of StairBlock.");
        }
        SlabBlock block = (SlabBlock)slabBlock;
        ResourceLocation textureLocation = new ResourceLocation(Objects.requireNonNull(this.rl(textureBlock)).m_135827_(), "block/" + this.name(textureBlock));
        this.slabBlock(block, textureLocation, textureLocation);
        ((ItemModelBuilder)this.itemModels().getBuilder(Objects.requireNonNull(this.rl((Block)block)).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name((Block)block))));
    }

    protected void slab(Block slabBlock, Block fullBlock, ResourceLocation top, ResourceLocation bottom, ResourceLocation side, ResourceLocation overlay) {
        if (!(slabBlock instanceof SlabBlock)) {
            throw new IllegalArgumentException(Objects.requireNonNull(this.rl(slabBlock)) + " is not a instance of StairBlock.");
        }
        SlabBlock block = (SlabBlock)slabBlock;
        ModelFile.ExistingModelFile doubleSlab = this.models().getExistingFile(new ResourceLocation(this.rl(fullBlock).m_135827_(), "block/" + this.name(fullBlock)));
        BlockModelBuilder bottomSlab = this.overlaySlab(this.name((Block)block), top, bottom, side, overlay);
        BlockModelBuilder topSlab = this.overlaySlabTop(this.name((Block)block) + "_top", top, bottom, side, overlay);
        this.getVariantBuilder((Block)block).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bottomSlab)}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)topSlab)}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)doubleSlab)});
        ((ItemModelBuilder)this.itemModels().getBuilder(Objects.requireNonNull(this.rl((Block)block)).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name((Block)block))));
    }

    protected void slab(Block slabBlock, Block fullBlock, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        if (!(slabBlock instanceof SlabBlock)) {
            throw new IllegalArgumentException(Objects.requireNonNull(this.rl(slabBlock)) + " is not a instance of SlabBlock.");
        }
        SlabBlock block = (SlabBlock)slabBlock;
        this.slabBlock(block, new ResourceLocation(this.rl(fullBlock).m_135827_(), "block/" + this.name(fullBlock)), side, bottom, top);
        ((ItemModelBuilder)this.itemModels().getBuilder(Objects.requireNonNull(this.rl((Block)block)).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name((Block)block))));
    }

    protected void slab(Block stairBlock, Block fullBlock, ResourceLocation side, ResourceLocation top) {
        this.slab(stairBlock, fullBlock, side, top, top);
    }

    protected void sidedSlab(Block slabBlock, Block fullBlock, ResourceLocation top, ResourceLocation bottom, ResourceLocation side) {
        if (!(slabBlock instanceof SlabBlock)) {
            throw new IllegalArgumentException(Objects.requireNonNull(this.rl(slabBlock)) + " is not a instance of StairBlock.");
        }
        SlabBlock block = (SlabBlock)slabBlock;
        ModelFile.ExistingModelFile doubleSlab = this.models().getExistingFile(new ResourceLocation(this.rl(fullBlock).m_135827_(), "block/" + this.name(fullBlock)));
        BlockModelBuilder bottomSlab = this.grassLikeSlab(this.name((Block)block), top, bottom, side);
        BlockModelBuilder topSlab = this.grassLikeSlabTop(this.name((Block)block) + "_top", top, bottom, side);
        this.getVariantBuilder((Block)block).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bottomSlab)}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)topSlab)}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)doubleSlab)});
        ((ItemModelBuilder)this.itemModels().getBuilder(Objects.requireNonNull(this.rl((Block)block)).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name((Block)block))));
    }

    protected void pillar(Block block) {
        if (!(block instanceof RotatedPillarBlock)) {
            throw new IllegalArgumentException(Objects.requireNonNull(this.rl(block)) + " is not a instance of RotatedPillarBlock.");
        }
        RotatedPillarBlock rotatedPillarBlock = (RotatedPillarBlock)block;
        this.logBlock(rotatedPillarBlock);
        ((ItemModelBuilder)this.itemModels().getBuilder(Objects.requireNonNull(this.rl(block)).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name(block))));
    }

    protected void nonRotatablePillar(Block block, ResourceLocation textureTopBot, ResourceLocation textureSides) {
        this.getVariantBuilder(block).forAllStates(blockState -> ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeColumn(this.name(block), textureSides, textureTopBot)).build());
        ((ItemModelBuilder)this.itemModels().getBuilder(Objects.requireNonNull(this.rl(block)).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name(block))));
    }

    protected void sapling(Supplier<? extends Block> sapling) {
        this.sapling(sapling.get());
    }

    protected void sapling(Block sapling) {
        this.getVariantBuilder(sapling).forAllStates(blockState -> ConfiguredModel.builder().modelFile((ModelFile)this.models().cross(this.name(sapling), this.blockTexture(sapling))).build());
        ((ItemModelBuilder)this.itemModels().getBuilder(Objects.requireNonNull(this.rl(sapling)).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name(sapling))));
    }

    private BlockModelBuilder overlayStair(String baseName, ResourceLocation top, ResourceLocation bottom, ResourceLocation side, ResourceLocation overlay) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName, new ResourceLocation("manascore", "block/overlay_stairs"))).texture("side", side)).texture("bottom", bottom)).texture("top", top)).texture("overlay", overlay);
    }

    private BlockModelBuilder overlayInnerStair(String baseName, ResourceLocation top, ResourceLocation bottom, ResourceLocation side, ResourceLocation overlay) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName, new ResourceLocation("manascore", "block/overlay_inner_stairs"))).texture("side", side)).texture("bottom", bottom)).texture("top", top)).texture("overlay", overlay);
    }

    private BlockModelBuilder overlayOuterStair(String baseName, ResourceLocation top, ResourceLocation bottom, ResourceLocation side, ResourceLocation overlay) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName, new ResourceLocation("manascore", "block/overlay_outer_stairs"))).texture("side", side)).texture("bottom", bottom)).texture("top", top)).texture("overlay", overlay);
    }

    private BlockModelBuilder overlaySlab(String baseName, ResourceLocation top, ResourceLocation bottom, ResourceLocation side, ResourceLocation overlay) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName, new ResourceLocation("manascore", "block/overlay_slab"))).texture("side", side)).texture("bottom", bottom)).texture("top", top)).texture("overlay", overlay);
    }

    private BlockModelBuilder overlaySlabTop(String baseName, ResourceLocation top, ResourceLocation bottom, ResourceLocation side, ResourceLocation overlay) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName, new ResourceLocation("manascore", "block/overlay_slab_top"))).texture("side", side)).texture("bottom", bottom)).texture("top", top)).texture("overlay", overlay);
    }

    private BlockModelBuilder grassLikeStair(String baseName, ResourceLocation top, ResourceLocation bottom, ResourceLocation side) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName, new ResourceLocation("manascore", "block/grass_like_stairs"))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
    }

    private BlockModelBuilder grassLikeInnerStair(String baseName, ResourceLocation top, ResourceLocation bottom, ResourceLocation side) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName, new ResourceLocation("manascore", "block/grass_like_inner_stairs"))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
    }

    private BlockModelBuilder grassLikeOuterStair(String baseName, ResourceLocation top, ResourceLocation bottom, ResourceLocation side) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName, new ResourceLocation("manascore", "block/grass_like_outer_stairs"))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
    }

    private BlockModelBuilder grassLikeSlab(String baseName, ResourceLocation top, ResourceLocation bottom, ResourceLocation side) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName, new ResourceLocation("manascore", "block/grass_like_slab"))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
    }

    private BlockModelBuilder grassLikeSlabTop(String baseName, ResourceLocation top, ResourceLocation bottom, ResourceLocation side) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName, new ResourceLocation("manascore", "block/grass_like_slab_top"))).texture("side", side)).texture("bottom", bottom)).texture("top", top);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$sidedStairs$8(ModelFile stairs, ModelFile stairsInner, ModelFile stairsOuter, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
        StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
        int yRot = (int)facing.m_122427_().m_122435_();
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
            yRot += 270;
        }
        if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
            yRot += 90;
        }
        boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
        return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$stairs$7(ModelFile stairs, ModelFile stairsInner, ModelFile stairsOuter, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
        StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
        int yRot = (int)facing.m_122427_().m_122435_();
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
            yRot += 270;
        }
        if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
            yRot += 90;
        }
        boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
        return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
    }
}

