/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.data.gen;

import com.github.manasmods.manascore.api.data.gen.annotation.GenerateBlockLoot;
import com.github.manasmods.manascore.api.util.ReflectionUtils;
import com.github.manasmods.manascore.api.util.StreamUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;

@ApiStatus.AvailableSince(value="2.0.3.0")
public abstract class BlockLoot
extends net.minecraft.data.loot.BlockLoot {
    private static final Logger log = LogManager.getLogger(BlockLoot.class);
    private static final Type GEN_ANNOTATION = Type.getType(GenerateBlockLoot.class);

    @ApiStatus.NonExtendable
    protected final void addTables() {
        this.loadTables();
        ArrayList<ModFileScanData.AnnotationData> annotations = new ArrayList<ModFileScanData.AnnotationData>();
        ModList.get().forEachModFile(modFile -> modFile.getScanResult().getAnnotations().stream().filter(annotationData -> GEN_ANNOTATION.equals((Object)annotationData.annotationType())).forEach(annotations::add));
        this.generateAnnotationLootTables(annotations);
    }

    @ApiStatus.NonExtendable
    private void generateAnnotationLootTables(List<ModFileScanData.AnnotationData> annotations) {
        annotations.forEach(annotationData -> {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(annotationData.clazz().getClassName());
            }
            catch (ClassNotFoundException e) {
                log.error("Could not load class " + annotationData.clazz().getClassName());
                log.throwing((Throwable)e);
            }
            if (clazz == null) {
                return;
            }
            List<Field> blockRegistryObjectFieldList = Arrays.stream(clazz.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getType().equals(RegistryObject.class)).filter(field -> {
                ParameterizedType registryObjectType = null;
                try {
                    registryObjectType = (ParameterizedType)field.getGenericType();
                }
                catch (ClassCastException e) {
                    log.error("Could not load generic type of field " + field.getName() + " in " + annotationData.clazz().getClassName());
                    log.throwing((Throwable)e);
                }
                if (registryObjectType == null) {
                    return false;
                }
                Class registryObjectClass = null;
                try {
                    registryObjectClass = (Class)registryObjectType.getActualTypeArguments()[0];
                }
                catch (ClassCastException e) {
                    log.error("Could not load generic type of field " + field.getName() + " in " + annotationData.clazz().getClassName() + ".");
                    log.throwing((Throwable)e);
                }
                if (registryObjectClass == null) {
                    return false;
                }
                return Block.class.isAssignableFrom(registryObjectClass);
            }).toList();
            this.generateDropSelfLootTables((ModFileScanData.AnnotationData)annotationData, blockRegistryObjectFieldList);
            this.generateDropOtherLootTables((ModFileScanData.AnnotationData)annotationData, blockRegistryObjectFieldList);
            this.generateDropOreLootTables((ModFileScanData.AnnotationData)annotationData, blockRegistryObjectFieldList);
            this.generateDropLeavesLootTables((ModFileScanData.AnnotationData)annotationData, blockRegistryObjectFieldList);
            this.generateDropDoorLootTables((ModFileScanData.AnnotationData)annotationData, blockRegistryObjectFieldList);
            this.generateDropSlabLootTables((ModFileScanData.AnnotationData)annotationData, blockRegistryObjectFieldList);
        });
    }

    @ApiStatus.NonExtendable
    private void generateDropSelfLootTables(ModFileScanData.AnnotationData annotationData, List<Field> blockRegistryObjectFieldList) {
        for (Field registryObjectField : blockRegistryObjectFieldList) {
            RegistryObject<Block> registryObject;
            if (!registryObjectField.isAnnotationPresent(GenerateBlockLoot.SelfDrop.class) || (registryObject = ReflectionUtils.getRegistryObjectFromField(annotationData, registryObjectField, Block.class)) == null) continue;
            log.debug("Generating block loot for registry object {}", (Object)registryObject.getId());
            this.m_124288_((Block)registryObject.get());
        }
    }

    @ApiStatus.NonExtendable
    private void generateDropOtherLootTables(ModFileScanData.AnnotationData annotationData, List<Field> blockRegistryObjectFieldList) {
        for (Field registryObjectField : blockRegistryObjectFieldList) {
            GenerateBlockLoot.OtherDrop annotation;
            RegistryObject<Block> registryObject;
            if (!registryObjectField.isAnnotationPresent(GenerateBlockLoot.OtherDrop.class) || (registryObject = ReflectionUtils.getRegistryObjectFromField(annotationData, registryObjectField, Block.class)) == null || (annotation = registryObjectField.getAnnotation(GenerateBlockLoot.OtherDrop.class)).value().isBlank()) continue;
            ResourceLocation itemId = ResourceLocation.m_135820_((String)annotation.value());
            Item lootItem = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (lootItem == null) {
                log.error("Could not find loot item {} for block {}", (Object)itemId, (Object)registryObject.getId());
                continue;
            }
            log.debug("Generating block loot for registry object {}", (Object)registryObject.getId());
            this.m_124147_((Block)registryObject.get(), (ItemLike)lootItem);
        }
    }

    @ApiStatus.NonExtendable
    private void generateDropOreLootTables(ModFileScanData.AnnotationData annotationData, List<Field> blockRegistryObjectFieldList) {
        for (Field registryObjectField : blockRegistryObjectFieldList) {
            GenerateBlockLoot.OreDrop annotation;
            RegistryObject<Block> registryObject;
            if (!registryObjectField.isAnnotationPresent(GenerateBlockLoot.OreDrop.class) || (registryObject = ReflectionUtils.getRegistryObjectFromField(annotationData, registryObjectField, Block.class)) == null || (annotation = registryObjectField.getAnnotation(GenerateBlockLoot.OreDrop.class)).value().isBlank()) continue;
            ResourceLocation itemId = ResourceLocation.m_135820_((String)annotation.value());
            Item lootItem = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (lootItem == null) {
                log.error("Could not find loot item {} for block {}", (Object)itemId, (Object)registryObject.getId());
                continue;
            }
            log.debug("Generating block loot for registry object {}", (Object)registryObject.getId());
            this.m_124175_((Block)registryObject.get(), block -> BlockLoot.m_124139_((Block)((Block)registryObject.get()), (Item)lootItem));
        }
    }

    @ApiStatus.NonExtendable
    private void generateDropLeavesLootTables(ModFileScanData.AnnotationData annotationData, List<Field> blockRegistryObjectFieldList) {
        for (Field registryObjectField : blockRegistryObjectFieldList) {
            GenerateBlockLoot.LeavesDrop annotation;
            RegistryObject<Block> registryObject;
            if (!registryObjectField.isAnnotationPresent(GenerateBlockLoot.LeavesDrop.class) || (registryObject = ReflectionUtils.getRegistryObjectFromField(annotationData, registryObjectField, Block.class)) == null || (annotation = registryObjectField.getAnnotation(GenerateBlockLoot.LeavesDrop.class)).value().isBlank()) continue;
            ResourceLocation itemId = ResourceLocation.m_135820_((String)annotation.value());
            Block saplingBlock = (Block)ForgeRegistries.BLOCKS.getValue(itemId);
            if (saplingBlock == null) {
                log.error("Could not find sapling block {} for block {}", (Object)itemId, (Object)registryObject.getId());
                continue;
            }
            log.debug("Generating block loot for registry object {}", (Object)registryObject.getId());
            this.m_124175_((Block)registryObject.get(), block -> BlockLoot.m_124157_((Block)((Block)registryObject.get()), (Block)saplingBlock, (float[])annotation.chances()));
        }
    }

    @ApiStatus.NonExtendable
    private void generateDropDoorLootTables(ModFileScanData.AnnotationData annotationData, List<Field> blockRegistryObjectFieldList) {
        for (Field registryObjectField : blockRegistryObjectFieldList) {
            RegistryObject<Block> registryObject;
            if (!registryObjectField.isAnnotationPresent(GenerateBlockLoot.DoorDrop.class) || (registryObject = ReflectionUtils.getRegistryObjectFromField(annotationData, registryObjectField, Block.class)) == null) continue;
            log.debug("Generating block loot for registry object {}", (Object)registryObject.getId());
            this.m_124175_((Block)registryObject.get(), net.minecraft.data.loot.BlockLoot::m_124137_);
        }
    }

    @ApiStatus.NonExtendable
    private void generateDropSlabLootTables(ModFileScanData.AnnotationData annotationData, List<Field> blockRegistryObjectFieldList) {
        for (Field registryObjectField : blockRegistryObjectFieldList) {
            RegistryObject<Block> registryObject;
            if (!registryObjectField.isAnnotationPresent(GenerateBlockLoot.SlabDrop.class) || (registryObject = ReflectionUtils.getRegistryObjectFromField(annotationData, registryObjectField, Block.class)) == null) continue;
            log.debug("Generating block loot for registry object {}", (Object)registryObject.getId());
            this.m_124175_((Block)registryObject.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
        }
    }

    protected abstract void loadTables();

    protected Iterable<Block> getKnownBlocks() {
        return ModList.get().getAllScanData().stream().flatMap(modFileScanData -> modFileScanData.getAnnotations().stream()).filter(annotationData -> GEN_ANNOTATION.equals((Object)annotationData.annotationType())).flatMap(annotationData -> {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(annotationData.clazz().getClassName());
            }
            catch (ClassNotFoundException e) {
                log.error("Could not load class " + annotationData.clazz().getClassName());
                log.throwing((Throwable)e);
            }
            if (clazz == null) {
                return Stream.of(new Block[0]);
            }
            return Arrays.stream(clazz.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getType().equals(DeferredRegister.class)).filter(field -> {
                ParameterizedType registryObjectType = null;
                try {
                    registryObjectType = (ParameterizedType)field.getGenericType();
                }
                catch (ClassCastException e) {
                    log.error("Could not load generic type of field " + field.getName() + " in " + annotationData.clazz().getClassName());
                    log.throwing((Throwable)e);
                }
                if (registryObjectType == null) {
                    return false;
                }
                Class registryObjectClass = null;
                try {
                    registryObjectClass = (Class)registryObjectType.getActualTypeArguments()[0];
                }
                catch (ClassCastException e) {
                    log.error("Could not load generic type of field " + field.getName() + " in " + annotationData.clazz().getClassName() + ".");
                    log.throwing((Throwable)e);
                }
                if (registryObjectClass == null) {
                    return false;
                }
                return Block.class.isAssignableFrom(registryObjectClass);
            }).filter(field -> field.isAnnotationPresent(GenerateBlockLoot.WithLootTables.class)).map(field -> ReflectionUtils.getDeferredRegisterFromField(annotationData, field, Block.class)).filter(Objects::nonNull).flatMap(blockDeferredRegister -> blockDeferredRegister.getEntries().stream()).filter(RegistryObject::isPresent).filter(StreamUtils.distinctBy(blockRegistryObject -> blockRegistryObject)).map(RegistryObject::get);
        }).toList();
    }
}

