/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.client.keybinding;

import com.github.manasmods.manascore.api.client.keybinding.KeybindingCategory;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.AvailableSince(value="1.0.0.0")
public class ManasKeybinding
extends KeyMapping {
    private static final HashMap<ManasKeybinding, Long> PRESSED_KEYBINDINGS = new HashMap();
    private final KeyBindingAction action;
    @Nullable
    private final Runnable release;

    public ManasKeybinding(String langKey, int defaultKey, KeybindingCategory category, KeyBindingAction action) {
        this(langKey, InputConstants.Type.KEYSYM.m_84895_(defaultKey), category, action, null);
    }

    public ManasKeybinding(String langKey, InputConstants.Key defaultKey, KeybindingCategory category, KeyBindingAction action) {
        this(langKey, defaultKey, category, action, null);
    }

    public ManasKeybinding(String langKey, KeybindingCategory category, KeyBindingAction action) {
        this(langKey, InputConstants.f_84822_.m_84873_(), category, action, null);
    }

    public ManasKeybinding(String langKey, KeybindingCategory category, KeyBindingAction action, @Nullable KeyBindingRelease release) {
        this(langKey, InputConstants.f_84822_.m_84873_(), category, action, release);
    }

    public ManasKeybinding(String langKey, int defaultKey, KeybindingCategory category, KeyBindingAction action, @Nullable KeyBindingRelease release) {
        this(langKey, InputConstants.Type.KEYSYM.m_84895_(defaultKey), category, action, release);
    }

    public ManasKeybinding(String langKey, InputConstants.Key defaultKey, KeybindingCategory category, KeyBindingAction action, @Nullable KeyBindingRelease release) {
        super(langKey, (IKeyConflictContext)KeyConflictContext.UNIVERSAL, defaultKey, category.getCategoryString());
        if (release == null) {
            this.action = action;
            this.release = null;
        } else {
            this.action = () -> {
                if (!PRESSED_KEYBINDINGS.containsKey((Object)this)) {
                    PRESSED_KEYBINDINGS.put(this, System.currentTimeMillis());
                    action.onPress();
                }
            };
            this.release = () -> {
                if (PRESSED_KEYBINDINGS.containsKey((Object)this)) {
                    long start = PRESSED_KEYBINDINGS.remove((Object)this);
                    long end = System.currentTimeMillis();
                    release.onRelease(end - start);
                }
            };
        }
    }

    public KeyBindingAction getAction() {
        return this.action;
    }

    @Nullable
    public Runnable getRelease() {
        return this.release;
    }

    @FunctionalInterface
    public static interface KeyBindingAction {
        public void onPress();
    }

    @FunctionalInterface
    public static interface KeyBindingRelease {
        public void onRelease(long var1);
    }
}

