/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.AvailableSince(value="1.0.1.0")
public final class FontRenderHelper {
    public static void renderScaledTextInArea(PoseStack poseStack, Font font, FormattedText text, float x, float y, float width, float height, Color color) {
        FontRenderHelper.renderScaledTextInArea(poseStack, font, text, x, y, width, height, color, 0.0f);
    }

    public static void renderScaledTextInArea(PoseStack poseStack, Font font, FormattedText text, float x, float y, float width, float height, int color) {
        FontRenderHelper.renderScaledTextInArea(poseStack, font, text, x, y, width, height, color, 0.0f);
    }

    public static void renderScaledTextInArea(PoseStack poseStack, Font font, FormattedText text, float x, float y, float width, float height, Color color, float spacePerLine) {
        FontRenderHelper.renderScaledTextInArea(poseStack, font, text, x, y, width, height, color, spacePerLine, 0.01f);
    }

    public static void renderScaledTextInArea(PoseStack poseStack, Font font, FormattedText text, float x, float y, float width, float height, int color, float spacePerLine) {
        FontRenderHelper.renderScaledTextInArea(poseStack, font, text, x, y, width, height, color, spacePerLine, 0.01f);
    }

    public static void renderScaledTextInArea(PoseStack poseStack, Font font, FormattedText text, float x, float y, float width, float height, Color color, float spacePerLine, float scalingSteps) {
        FontRenderHelper.renderScaledTextInArea(poseStack, font, text, x, y, width, height, color.getRGB(), spacePerLine, scalingSteps);
    }

    public static void renderScaledTextInArea(PoseStack poseStack, Font font, FormattedText text, float x, float y, float width, float height, int color, float spacePerLine, float scalingSteps) {
        float scaling = 1.0f;
        while (true) {
            List formattedCharSequences = font.m_92923_(text, Math.round(width / scaling));
            float f = formattedCharSequences.size();
            Objects.requireNonNull(font);
            if (!(f * (9.0f + spacePerLine) * scaling > height)) break;
            scaling -= scalingSteps;
        }
        FontRenderHelper.renderScaledText(poseStack, font, scaling, font.m_92923_(text, Math.round(width / scaling)), x, y, color, spacePerLine);
    }

    public static void renderScaledWrappedText(PoseStack poseStack, Font font, FormattedText text, float x, float y, float width, Color color) {
        FontRenderHelper.renderScaledWrappedText(poseStack, font, text, x, y, width, color, 0.0f);
    }

    public static void renderScaledWrappedText(PoseStack poseStack, Font font, FormattedText text, float x, float y, float width, int color) {
        FontRenderHelper.renderScaledWrappedText(poseStack, font, text, x, y, width, color, 0.0f);
    }

    public static void renderScaledWrappedText(PoseStack poseStack, Font font, FormattedText text, float x, float y, float width, Color color, float spacePerLine) {
        FontRenderHelper.renderScaledWrappedText(poseStack, font, text, x, y, width, color.getRGB(), spacePerLine);
    }

    public static void renderScaledWrappedText(PoseStack poseStack, Font font, FormattedText text, float x, float y, float width, int color, float spacePerLine) {
        float scaling = 1.0f;
        while (true) {
            List sequences = font.m_92923_(text, Minecraft.m_91087_().m_91268_().m_85443_());
            float currentScaling = scaling;
            int maxWidth = sequences.stream().map(seq -> Float.valueOf((float)font.m_92724_(seq) * currentScaling)).mapMultiToInt((aFloat, intConsumer) -> intConsumer.accept(Math.round(aFloat.floatValue()))).max().orElse(0);
            if (!((float)maxWidth > width)) break;
            scaling -= 0.01f;
        }
        FontRenderHelper.renderScaledText(poseStack, font, scaling, font.m_92923_(text, Math.round(width / scaling)), x, y, color, spacePerLine);
    }

    private static void renderScaledText(PoseStack poseStack, Font font, float scaling, List<FormattedCharSequence> text, float x, float y, int color, float spacePerLine) {
        poseStack.m_85841_(scaling, scaling, scaling);
        for (FormattedCharSequence charSequence : text) {
            font.m_92877_(poseStack, charSequence, x / scaling, y / scaling, color);
            Objects.requireNonNull(font);
            y += (9.0f + spacePerLine) * scaling;
        }
        poseStack.m_85841_(1.0f / scaling, 1.0f / scaling, 1.0f / scaling);
    }

    private FontRenderHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

