/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.manascore.api.attribute;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0.0")
public final class AttributeModifierHelper {
    private static final Logger log = LogManager.getLogger(AttributeModifierHelper.class);

    public static void setModifier(LivingEntity entity, Attribute attribute, AttributeModifier modifier) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance == null) {
            log.error("Tried to modify an unknown Attribute: {}", (Object)ForgeRegistries.ATTRIBUTES.getKey((Object)attribute));
            return;
        }
        double oldMaxHealth = attribute == Attributes.f_22276_ ? (double)entity.m_21233_() : 0.0;
        Optional.ofNullable(instance.m_22111_(modifier.m_22209_())).ifPresent(modifier1 -> instance.m_22120_(modifier1.m_22209_()));
        instance.m_22125_(modifier);
        if (attribute == Attributes.f_22276_) {
            double newMaxHealth = entity.m_21233_();
            if (newMaxHealth > oldMaxHealth) {
                double healAmount = newMaxHealth - oldMaxHealth;
                entity.m_5634_((float)healAmount);
            } else if ((double)entity.m_21223_() > newMaxHealth) {
                entity.m_21153_((float)newMaxHealth);
            }
        }
    }

    public static void addModifier(LivingEntity entity, Attribute attribute, UUID attributeModifierId, String attributeModifierName, double amount, AttributeModifier.Operation attributeOperation) {
        AttributeModifierHelper.setModifier(entity, attribute, new AttributeModifier(attributeModifierId, attributeModifierName, amount, attributeOperation));
    }

    public static void removeModifier(LivingEntity entity, Attribute attribute, UUID attributeModifierId) {
        Optional.ofNullable(entity.m_21051_(attribute)).ifPresent(attributeInstance -> attributeInstance.m_22120_(attributeModifierId));
    }

    public static void removeModifier(LivingEntity entity, Attribute attribute, AttributeModifier modifier) {
        AttributeModifierHelper.removeModifier(entity, attribute, modifier.m_22209_());
    }

    private AttributeModifierHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

