/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.hrznstudio.titanium.item.BasicItem;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class ConfigurationToolItem
extends BasicItem {
    public static final String NBT_MODE = "Mode";

    public static ConfigurationAction getAction(ItemStack stack) {
        if (stack.m_41782_()) {
            return ConfigurationAction.valueOf(stack.m_41784_().m_128461_(NBT_MODE));
        }
        return ConfigurationAction.LOCKING;
    }

    public ConfigurationToolItem() {
        super(new Item.Properties().m_41491_((CreativeModeTab)FunctionalStorage.TAB).m_41487_(1));
    }

    public void m_7836_(ItemStack p_41447_, Level p_41448_, Player p_41449_) {
        super.m_7836_(p_41447_, p_41448_, p_41449_);
        this.initNbt(p_41447_);
    }

    private ItemStack initNbt(ItemStack stack) {
        stack.m_41784_().m_128359_(NBT_MODE, ConfigurationAction.LOCKING.name());
        return stack;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)this.initNbt(new ItemStack((ItemLike)this)));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        Level level = context.m_43725_();
        BlockEntity blockEntity = level.m_7702_(pos);
        ConfigurationAction configuractionAction = ConfigurationToolItem.getAction(stack);
        if (blockEntity instanceof ControllableDrawerTile) {
            if (configuractionAction == ConfigurationAction.LOCKING) {
                ((ControllableDrawerTile)blockEntity).toggleLocking();
            } else {
                ((ControllableDrawerTile)blockEntity).toggleOption(configuractionAction);
                if (configuractionAction.getMax() > 1) {
                    context.m_43723_().m_5661_((Component)Component.m_237115_((String)("configurationtool.configmode.indicator.mode_" + ((ControllableDrawerTile)blockEntity).getDrawerOptions().getAdvancedValue(configuractionAction))).m_6270_(Style.f_131099_.m_131148_(configuractionAction.getColor())), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && player.m_6144_()) {
            ConfigurationAction action = ConfigurationToolItem.getAction(stack);
            ConfigurationAction newAction = ConfigurationAction.values()[(Arrays.asList(ConfigurationAction.values()).indexOf((Object)action) + 1) % ConfigurationAction.values().length];
            stack.m_41784_().m_128359_(NBT_MODE, newAction.name());
            player.m_5661_((Component)Component.m_237113_((String)"Swapped mode to ").m_6270_(Style.f_131099_.m_131148_(newAction.getColor())).m_7220_((Component)Component.m_237115_((String)("configurationtool.configmode." + newAction.name().toLowerCase(Locale.ROOT)))), true);
            player.m_5496_(SoundEvents.f_12016_, 0.5f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(p_41432_, player, hand);
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        ConfigurationAction linkingMode = ConfigurationToolItem.getAction(stack);
        if (key == null) {
            tooltip.add((Component)Component.m_237115_((String)"configurationtool.configmode").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237115_((String)("configurationtool.configmode." + linkingMode.name().toLowerCase(Locale.ROOT))).m_130948_(Style.f_131099_.m_131148_(linkingMode.getColor()))));
            tooltip.add((Component)Component.m_237113_((String)"").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"configurationtool.use").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public static enum ConfigurationAction {
        LOCKING(TextColor.m_131266_((int)new Color(40, 131, 250).getRGB()), 1),
        TOGGLE_NUMBERS(TextColor.m_131266_((int)new Color(250, 145, 40).getRGB()), 1),
        TOGGLE_RENDER(TextColor.m_131266_((int)new Color(100, 250, 40).getRGB()), 1),
        TOGGLE_UPGRADES(TextColor.m_131266_((int)new Color(166, 40, 250).getRGB()), 1),
        INDICATOR(TextColor.m_131266_((int)new Color(255, 40, 40).getRGB()), 3);

        private final TextColor color;
        private final int max;

        private ConfigurationAction(TextColor color, int max) {
            this.color = color;
            this.max = max;
        }

        public TextColor getColor() {
            return this.color;
        }

        public int getMax() {
            return this.max;
        }
    }
}

