/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.client.gui.DrawerInfoGuiAddon;
import com.buuz135.functionalstorage.inventory.EnderInventoryHandler;
import com.buuz135.functionalstorage.network.EnderDrawerSyncMessage;
import com.buuz135.functionalstorage.world.EnderSavedData;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.network.Message;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EnderDrawerTile
extends ItemControllableDrawerTile<EnderDrawerTile> {
    @Save
    private String frequency = UUID.randomUUID().toString();
    private LazyOptional<IItemHandler> lazyStorage = LazyOptional.empty();

    public EnderDrawerTile(BasicTileBlock<EnderDrawerTile> base, BlockEntityType<EnderDrawerTile> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
    }

    public void m_142339_(Level p_155231_) {
        super.m_142339_(p_155231_);
        this.lazyStorage.invalidate();
        this.lazyStorage = LazyOptional.of(() -> EnderSavedData.getInstance((LevelAccessor)this.f_58857_).getFrequency(this.frequency));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new DrawerInfoGuiAddon(64, 16, new ResourceLocation("functionalstorage", "textures/blocks/ender_front.png"), 1, FunctionalStorage.DrawerType.X_1.getSlotPosition(), integer -> this.getStorage().getStackInSlot(integer.intValue()), integer -> this.getStorage().getSlotLimit(integer.intValue())));
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, EnderDrawerTile blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (level.m_46467_() % 20L == 0L) {
            FunctionalStorage.NETWORK.sendToNearby(level, pos, 32, (Message)new EnderDrawerSyncMessage(this.frequency, (EnderInventoryHandler)this.getStorage()));
        }
        if (level.m_46467_() % 10L == 0L) {
            EnderInventoryHandler handler = EnderSavedData.getInstance((LevelAccessor)this.f_58857_).getFrequency(this.frequency);
            if (handler.isLocked() != this.isLocked()) {
                super.setLocked(handler.isLocked());
            }
            if (!handler.isVoid()) {
                for (int i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
                    ItemStack stack = this.getUtilityUpgrades().getStackInSlot(i);
                    if (stack.m_41619_() || !stack.m_150930_((Item)FunctionalStorage.VOID_UPGRADE.get())) continue;
                    handler.setVoidItems(true);
                    stack.m_41774_(1);
                    break;
                }
            }
        }
    }

    @Override
    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        InteractionResult result = super.onSlotActivated(playerIn, hand, facing, hitX, hitY, hitZ, slot);
        if (slot != -1) {
            FunctionalStorage.NETWORK.sendToNearby(this.f_58857_, this.m_58899_(), 32, (Message)new EnderDrawerSyncMessage(this.frequency, (EnderInventoryHandler)this.getStorage()));
        }
        return result;
    }

    @Override
    public void onClicked(Player playerIn, int slot) {
        super.onClicked(playerIn, slot);
        if (slot != -1) {
            FunctionalStorage.NETWORK.sendToNearby(this.f_58857_, this.m_58899_(), 32, (Message)new EnderDrawerSyncMessage(this.frequency, (EnderInventoryHandler)this.getStorage()));
        }
    }

    public void m_142466_(CompoundTag compound) {
        String oldFreq = this.frequency;
        super.m_142466_(compound);
        if (!this.frequency.equalsIgnoreCase(oldFreq) && this.f_58857_ instanceof ServerLevel) {
            this.setFrequency(this.frequency);
        }
    }

    @Override
    public void setLocked(boolean locked) {
        super.setLocked(locked);
        EnderSavedData.getInstance((LevelAccessor)this.f_58857_).getFrequency(this.frequency).setLocked(locked);
    }

    @Override
    public boolean isVoid() {
        return EnderSavedData.getInstance((LevelAccessor)this.f_58857_).getFrequency(this.frequency).isVoid();
    }

    @NotNull
    public EnderDrawerTile getSelf() {
        return this;
    }

    @Override
    public int getStorageSlotAmount() {
        return 0;
    }

    @Override
    public IItemHandler getStorage() {
        return (IItemHandler)this.lazyStorage.resolve().get();
    }

    @Override
    public LazyOptional<IItemHandler> getOptional() {
        return this.lazyStorage;
    }

    @Override
    public boolean isEverythingEmpty() {
        int i;
        EnderInventoryHandler inventoryHandler = EnderSavedData.getInstance((LevelAccessor)this.f_58857_).getFrequency(this.frequency);
        for (i = 0; i < inventoryHandler.getSlots(); ++i) {
            if (inventoryHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        for (i = 0; i < this.getStorageUpgrades().getSlots(); ++i) {
            if (this.getStorageUpgrades().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        for (i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
            if (this.getUtilityUpgrades().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getBaseSize(int lost) {
        return 1;
    }

    public void setFrequency(String frequency) {
        if (frequency == null) {
            return;
        }
        this.frequency = frequency;
        this.lazyStorage.invalidate();
        this.lazyStorage = LazyOptional.of(() -> EnderSavedData.getInstance((LevelAccessor)this.f_58857_).getFrequency(this.frequency));
        this.markForUpdate();
    }

    public String getFrequency() {
        return this.frequency;
    }
}

