/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.entity;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.config.MobCaptureCardConfig;
import java.util.Random;
import net.minecraft.core.Registry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LivingEntityEvents {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Random RANDOM = new Random();

    private LivingEntityEvents() {
    }

    public static void handleLivingEntityDeathEvent(LivingEntity livingEntity, DamageSource damageSource) {
        if (!MobCaptureCardConfig.dropMobCaptureCardOnKill) {
            return;
        }
        if (MobCaptureCardConfig.requirePlayerKill && (damageSource.m_7639_() == null || !(damageSource.m_7639_() instanceof Player))) {
            return;
        }
        String entityName = Registry.f_122826_.m_7981_((Object)livingEntity.m_6095_()).toString();
        if (MobCaptureCardConfig.mobCaptureCardKillDropDenyList.contains(entityName) || !MobCaptureCardConfig.mobCaptureCardKillDropAllowList.isEmpty() && !MobCaptureCardConfig.mobCaptureCardKillDropAllowList.contains(entityName)) {
            log.debug("[Skip] Mob capture card kill drop for {}.", (Object)entityName);
            return;
        }
        if (MobCaptureCardConfig.mobCaptureCardKillDropChance > 0.0f && RANDOM.nextFloat() > MobCaptureCardConfig.mobCaptureCardKillDropChance) {
            return;
        }
        ItemStack itemStack = MobCaptureManager.getMobCaptureCardItem(livingEntity);
        if (itemStack != null) {
            log.debug("Dropped mob capture card {} for {}.", (Object)itemStack, (Object)livingEntity);
            livingEntity.m_5552_(itemStack, 0.5f);
        } else {
            log.error("Failed to drop mob capture card for {}.", (Object)livingEntity);
        }
    }
}

