/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.compat.CompatConstants;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.Villager;

public class MobVariantData {
    public static final String VARIANT_TAG = "Variant";
    public static final String LARGE_VARIANT = "large";
    public static final String MEDIUM_VARIANT = "medium";
    public static final String SMALL_VARIANT = "small";
    public static final String TINY_VARIANT = "tiny";
    private static final Map<CatVariant, String> CAT_VARIANT_MAP = new HashMap<CatVariant, String>();
    private static final Map<FrogVariant, String> FROG_VARIANT_MAP = new HashMap<FrogVariant, String>();
    private static final Map<ResourceLocation, String> SWAMPIER_SWAMPS_FROG_VARIANT_MAP = new HashMap<ResourceLocation, String>();

    private MobVariantData() {
    }

    public static String getVariant(EntityType<?> entityType) {
        return null;
    }

    public static String getVariant(LivingEntity livingEntity) {
        if (livingEntity instanceof Cat) {
            Cat cat = (Cat)livingEntity;
            return CAT_VARIANT_MAP.get(cat.m_218139_());
        }
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            return villager.m_7141_().m_35571_().f_35600_();
        }
        if (livingEntity instanceof MagmaCube) {
            MagmaCube magmaCube = (MagmaCube)livingEntity;
            return MobVariantData.getSizeVariant(magmaCube.m_33632_());
        }
        if (livingEntity instanceof Slime) {
            Slime slime = (Slime)livingEntity;
            return MobVariantData.getSizeVariant(slime.m_33632_());
        }
        if (livingEntity instanceof Frog) {
            Frog frog = (Frog)livingEntity;
            String frogVariant = FROG_VARIANT_MAP.get(frog.m_218524_());
            if (frogVariant != null) {
                return frogVariant;
            }
            if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
                return SWAMPIER_SWAMPS_FROG_VARIANT_MAP.get(frog.m_218524_().f_218188_());
            }
        }
        return null;
    }

    public static String getVariant(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return null;
        }
        if (compoundTag.m_128441_(VARIANT_TAG)) {
            return compoundTag.m_128461_(VARIANT_TAG);
        }
        if (compoundTag.m_128441_(VARIANT_TAG.toLowerCase(Locale.ROOT))) {
            return compoundTag.m_128461_(VARIANT_TAG.toLowerCase(Locale.ROOT));
        }
        return null;
    }

    public static String getSizeVariant(float size) {
        if (size <= 1.0f) {
            return TINY_VARIANT;
        }
        if (size <= 2.0f) {
            return SMALL_VARIANT;
        }
        if (size < 4.0f) {
            return MEDIUM_VARIANT;
        }
        if (size >= 4.0f) {
            return LARGE_VARIANT;
        }
        return "";
    }

    public static CatVariant getCatVariant(String variant) {
        for (Map.Entry<CatVariant, String> entry : CAT_VARIANT_MAP.entrySet()) {
            if (!entry.getValue().equals(variant)) continue;
            return entry.getKey();
        }
        return CatVariant.f_218141_;
    }

    public static FrogVariant getFrogVariant(String variant) {
        for (Map.Entry<FrogVariant, String> entry : FROG_VARIANT_MAP.entrySet()) {
            if (!entry.getValue().equals(variant)) continue;
            return entry.getKey();
        }
        if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
            try {
                ResourceLocation resourceLocation = new ResourceLocation("swampier_swamps", variant + "_variant");
                if (Registry.f_235734_.m_7804_(resourceLocation)) {
                    return (FrogVariant)Registry.f_235734_.m_7745_(resourceLocation);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (variant) {
                case "orange": {
                    return FrogVariant.f_218185_;
                }
                case "light_gray": {
                    return FrogVariant.f_218186_;
                }
                case "green": {
                    return FrogVariant.f_218187_;
                }
            }
        }
        return FrogVariant.f_218185_;
    }

    static {
        CAT_VARIANT_MAP.put(CatVariant.f_218140_, "tabby");
        CAT_VARIANT_MAP.put(CatVariant.f_218141_, "black");
        CAT_VARIANT_MAP.put(CatVariant.f_218142_, "red");
        CAT_VARIANT_MAP.put(CatVariant.f_218143_, "siamese");
        CAT_VARIANT_MAP.put(CatVariant.f_218144_, "british_shorthair");
        CAT_VARIANT_MAP.put(CatVariant.f_218145_, "calico");
        CAT_VARIANT_MAP.put(CatVariant.f_218146_, "persian");
        CAT_VARIANT_MAP.put(CatVariant.f_218147_, "ragdoll");
        CAT_VARIANT_MAP.put(CatVariant.f_218148_, "white");
        CAT_VARIANT_MAP.put(CatVariant.f_218149_, "jellie");
        CAT_VARIANT_MAP.put(CatVariant.f_218150_, "all_black");
        FROG_VARIANT_MAP.put(FrogVariant.f_218187_, "cold");
        FROG_VARIANT_MAP.put(FrogVariant.f_218186_, "warm");
        FROG_VARIANT_MAP.put(FrogVariant.f_218185_, "temperate");
        if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_white.png"), "white");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_magenta.png"), "magenta");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_light_blue.png"), "light_blue");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_yellow.png"), "yellow");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_lime.png"), "lime");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_pink.png"), "pink");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_gray.png"), "gray");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_cyan.png"), "cyan");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_purple.png"), "purple");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_blue.png"), "blue");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_brown.png"), "brown");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_red.png"), "red");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_black.png"), "black");
        }
    }
}

