/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer.manager;

import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RendererManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Map<BlockPos, Entity> entityMap = new HashMap<BlockPos, Entity>();

    private RendererManager() {
    }

    public static Entity getOrCreateEntity(MobFarmBlockEntity mobFarmBlockEntity) {
        if (mobFarmBlockEntity == null) {
            return null;
        }
        BlockPos blockPos = mobFarmBlockEntity.m_58899_();
        if (!mobFarmBlockEntity.hasCapturedMob()) {
            entityMap.remove(blockPos);
            return null;
        }
        if (entityMap.containsKey(blockPos)) {
            return entityMap.get(blockPos);
        }
        Entity entity = RendererManager.createEntity(mobFarmBlockEntity);
        if (entity == null) {
            return null;
        }
        return entityMap.put(blockPos, entity);
    }

    public static Entity getEntity(BlockPos blockPos) {
        return entityMap.get(blockPos);
    }

    public static void removeEntity(MobFarmBlockEntity mobFarmBlockEntity) {
        RendererManager.removeEntity(mobFarmBlockEntity.m_58899_());
    }

    public static void removeEntity(BlockPos blockPos) {
        entityMap.remove(blockPos);
    }

    private static Entity createEntity(MobFarmBlockEntity mobFarmBlockEntity) {
        if (mobFarmBlockEntity == null || mobFarmBlockEntity.m_58904_() == null) {
            log.error("Unable to create entity for Mob Farm Block Entity {}", (Object)mobFarmBlockEntity);
            return null;
        }
        MobCaptureData mobCaptureData = mobFarmBlockEntity.getMobCaptureData();
        if (mobCaptureData == null) {
            log.error("Unable to get Mob Capture data from Mob Farm Block Entity {}", (Object)mobFarmBlockEntity);
            return null;
        }
        EntityType<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            log.error("Unable to get entity type from Mob Capture data {}", (Object)mobCaptureData);
            return null;
        }
        Entity entity = entityType.m_20615_(mobFarmBlockEntity.m_58904_());
        if (entity == null) {
            log.error("Unable to create entity for entity type {}", entityType);
            return null;
        }
        entity.m_8119_();
        entity.m_6034_(0.0, 0.0, 0.0);
        entity.m_20256_(Vec3.f_82478_);
        entity.f_19790_ = 0.0;
        entity.f_19791_ = 0.0;
        entity.f_19792_ = 0.0;
        entity.m_6853_(true);
        entity.f_146794_ = 0.0f;
        entity.m_8119_();
        entity.m_5616_(mobFarmBlockEntity.m_58904_().f_46441_.m_188501_() * 60.0f);
        entity.m_5618_(mobFarmBlockEntity.m_58904_().f_46441_.m_188501_() * 10.0f);
        entity.f_19860_ = entity.m_146909_();
        entity.f_19859_ = entity.m_146908_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_20925_ = 0.0f;
            livingEntity.f_20924_ = 0.0f;
            livingEntity.f_20923_ = 0.0f;
            livingEntity.f_20887_ = 0.0f;
            livingEntity.m_8119_();
        }
        entity.m_20258_(mobCaptureData.data());
        entity.m_8119_();
        if (entity instanceof AbstractFish) {
            AbstractFish fishEntity = (AbstractFish)entity;
            fishEntity.m_20242_(true);
            fishEntity.m_20282_(true);
        }
        if (entity instanceof Sheep) {
            Sheep sheepEntity = (Sheep)entity;
            sheepEntity.m_29878_(false);
            if (mobCaptureData.hasColor()) {
                sheepEntity.m_29855_(mobCaptureData.color());
            }
        }
        if (entity instanceof PathfinderMob) {
            PathfinderMob newPathfinderMob = (PathfinderMob)entity;
            newPathfinderMob.m_21557_(true);
            newPathfinderMob.m_20225_(true);
            newPathfinderMob.f_19794_ = true;
        }
        entity.f_19794_ = true;
        return entity;
    }
}

