/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.model;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ModelManagerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    public static final Set<String> KNOWN_MISSING_MODELS = new HashSet<String>();
    public static final String LOG_PREFIX = "[Model Manager]";
    public static final String MODEL_SEARCH_PATH = "/easy_mob_farm/mob_capture_card/";
    public static final ModelResourceLocation DEFAULT_MODEL = new ModelResourceLocation(new ResourceLocation("easy_mob_farm", "mob_capture_card/default"), "inventory");
    public static final ModelResourceLocation DEFAULT_UNCOMMON_MODEL = new ModelResourceLocation(new ResourceLocation("easy_mob_farm", "mob_capture_card/default_uncommon"), "inventory");
    public static final ModelResourceLocation DEFAULT_RARE_MODEL = new ModelResourceLocation(new ResourceLocation("easy_mob_farm", "mob_capture_card/default_rare"), "inventory");
    public static final ModelResourceLocation DEFAULT_EPIC_MODEL = new ModelResourceLocation(new ResourceLocation("easy_mob_farm", "mob_capture_card/default_epic"), "inventory");
    public static final ModelResourceLocation DEFAULT_FISH_MODEL = new ModelResourceLocation(new ResourceLocation("easy_mob_farm", "mob_capture_card/default_fish"), "inventory");

    private static boolean isFish(EntityType<?> entityType) {
        ResourceLocation entityId = EntityType.m_20613_(entityType);
        Item correspondingItem = (Item)Registry.f_122827_.m_7745_(entityId);
        return correspondingItem != Items.f_41852_ && correspondingItem.m_204114_().m_203656_(ItemTags.f_13156_);
    }

    public static ModelResourceLocation getModelResourceLocation(ResourceLocation resourceLocation) {
        return new ModelResourceLocation(new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_().replaceFirst("^models/", "").replaceFirst("^item/", "").replaceFirst("\\.json$", "")), "inventory");
    }

    public static boolean isMobCaptureCardModel(ResourceLocation resourceLocation) {
        return resourceLocation != null && resourceLocation.m_135815_().contains(MODEL_SEARCH_PATH);
    }

    default public BakedModel getModel(ModelResourceLocation modelResourceLocation) {
        if (modelResourceLocation == null) {
            return null;
        }
        BakedModel bakedModel = Minecraft.m_91087_().m_91304_().m_119422_(modelResourceLocation);
        if (bakedModel == Minecraft.m_91087_().m_91304_().m_119409_()) {
            if (KNOWN_MISSING_MODELS.add(modelResourceLocation.toString())) {
                log.error("{} Missing model for '{}'", (Object)LOG_PREFIX, (Object)modelResourceLocation);
            }
            return null;
        }
        return bakedModel != Minecraft.m_91087_().m_91304_().m_119409_() ? bakedModel : null;
    }

    default public BakedModel getModel(String type, String variant, DyeColor color) {
        BakedModel bakedModel;
        MobCaptureCardDefinition mobCaptureCardDefinition = MobCaptureCardDefinitionManager.get(new ResourceLocation(type));
        if (mobCaptureCardDefinition == null) {
            return null;
        }
        ModelResourceLocation modelResourceLocation = null;
        if (variant != null && !variant.isBlank() && color != null) {
            if (mobCaptureCardDefinition.variants().containsKey(variant) && mobCaptureCardDefinition.variants().get(variant).colors().containsKey(color)) {
                modelResourceLocation = ModelManagerInterface.getModelResourceLocation(mobCaptureCardDefinition.variants().get(variant).colors().get(color).model());
            }
        } else if (variant != null && !variant.isBlank()) {
            if (mobCaptureCardDefinition.variants().containsKey(variant)) {
                modelResourceLocation = ModelManagerInterface.getModelResourceLocation(mobCaptureCardDefinition.variants().get(variant).model());
            }
        } else if (color != null) {
            String colorName = color.m_41065_().toLowerCase(Locale.ROOT);
            if (mobCaptureCardDefinition.colors().containsKey(colorName)) {
                modelResourceLocation = ModelManagerInterface.getModelResourceLocation(mobCaptureCardDefinition.colors().get(colorName).model());
            }
        }
        ModelResourceLocation defaultModelResourceLocation = ModelManagerInterface.getModelResourceLocation(mobCaptureCardDefinition.model());
        if (modelResourceLocation == null) {
            modelResourceLocation = defaultModelResourceLocation;
        }
        if ((bakedModel = this.getModel(modelResourceLocation)) == Minecraft.m_91087_().m_91304_().m_119409_()) {
            bakedModel = Minecraft.m_91087_().m_91304_().m_119422_(defaultModelResourceLocation);
        }
        return bakedModel;
    }

    default public BakedModel getModel(String type) {
        return this.getModel(type, null, null);
    }

    default public BakedModel getModel(Rarity rarity) {
        if (rarity == null) {
            return null;
        }
        ModelResourceLocation modelResourceLocation = switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case Rarity.COMMON -> DEFAULT_MODEL;
            case Rarity.UNCOMMON -> DEFAULT_UNCOMMON_MODEL;
            case Rarity.RARE -> DEFAULT_RARE_MODEL;
            case Rarity.EPIC -> DEFAULT_EPIC_MODEL;
        };
        return this.getModel(modelResourceLocation);
    }

    default public BakedModel getModel(EntityType<?> entityType) {
        if (entityType == null || !ModelManagerInterface.isFish(entityType)) {
            return null;
        }
        return this.getModel(DEFAULT_FISH_MODEL);
    }

    default public BakedModel getDefaultModel() {
        return this.getModel(DEFAULT_MODEL);
    }
}

