/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_forge.data.Constants;
import com.natamus.collective_common_forge.functions.ItemFunctions;
import com.natamus.collective_common_forge.functions.NumberFunctions;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GearFunctions {
    public static void setPlayerGearFromGearString(Player player, String gearString) {
        GearFunctions.setPlayerGearFromGearString(player, gearString, false);
    }

    public static void setPlayerGearFromGearString(Player player, String gearString, boolean parseActiveEffects) {
        Registry mobEffectRegistry = null;
        if (parseActiveEffects) {
            mobEffectRegistry = player.f_19853_.m_5962_().m_175515_(Registry.f_122900_);
            player.m_21219_();
        }
        boolean emptiedInventory = false;
        for (String line : GearFunctions.getGearStringSplit(gearString)) {
            String slotString = GearFunctions.getSlotStringFromLine(line);
            if (slotString.equalsIgnoreCase("effects") && parseActiveEffects) {
                if (mobEffectRegistry == null) continue;
                List<MobEffectInstance> mobEffectInstanceList = GearFunctions.getEffectsFromLine((Registry<MobEffect>)mobEffectRegistry, line);
                for (MobEffectInstance mobEffectInstance : mobEffectInstanceList) {
                    player.m_7292_(mobEffectInstance);
                }
                continue;
            }
            ItemStack itemStack = GearFunctions.getItemStackFromGearStringLine(line);
            if (itemStack == null || itemStack.m_41619_()) continue;
            if (!emptiedInventory) {
                player.m_150109_().m_6211_();
                emptiedInventory = true;
            }
            if (NumberFunctions.isNumeric(slotString)) {
                player.m_150109_().m_6836_(Integer.parseInt(slotString), itemStack);
                continue;
            }
            EquipmentSlot equipmentSlot = GearFunctions.getEquipmentSlotFromSlotString(slotString);
            if (equipmentSlot == null) continue;
            player.m_8061_(equipmentSlot, itemStack);
        }
    }

    public static void setInventoryFromGearString(Inventory inventory, String gearString) {
        for (String line : GearFunctions.getGearStringSplit(gearString)) {
            ItemStack itemStack = GearFunctions.getItemStackFromGearStringLine(line);
            if (itemStack == null || itemStack.m_41619_()) continue;
            String slotString = GearFunctions.getSlotStringFromLine(line);
            if (NumberFunctions.isNumeric(slotString)) {
                inventory.m_6836_(Integer.parseInt(slotString), itemStack);
                continue;
            }
            EquipmentSlot equipmentSlot = GearFunctions.getEquipmentSlotFromSlotString(slotString);
            if (equipmentSlot.equals((Object)EquipmentSlot.HEAD)) {
                inventory.f_35975_.set(3, (Object)itemStack);
            }
            if (equipmentSlot.equals((Object)EquipmentSlot.CHEST)) {
                inventory.f_35975_.set(2, (Object)itemStack);
            }
            if (equipmentSlot.equals((Object)EquipmentSlot.LEGS)) {
                inventory.f_35975_.set(1, (Object)itemStack);
            }
            if (equipmentSlot.equals((Object)EquipmentSlot.FEET)) {
                inventory.f_35975_.set(0, (Object)itemStack);
            }
            if (!equipmentSlot.equals((Object)EquipmentSlot.OFFHAND)) continue;
            inventory.f_35976_.set(0, (Object)itemStack);
        }
    }

    public static String getGearStringFromPlayer(Player player) {
        return GearFunctions.getGearStringFromPlayer(player, false);
    }

    public static String getGearStringFromPlayer(Player player, boolean parseActiveEffects) {
        StringBuilder gearStringBuilder = new StringBuilder();
        for (EquipmentSlot equipmentSlot : Constants.equipmentSlots) {
            if (!gearStringBuilder.isEmpty()) {
                gearStringBuilder.append("\n");
            }
            String equipmentSlotString = equipmentSlot.m_20751_();
            ItemStack equipmentSlotStack = player.m_6844_(equipmentSlot);
            if (!equipmentSlotStack.m_41619_()) {
                String nbtString = GearFunctions.getFormattedNBTStringFromItemStack(equipmentSlotStack);
                gearStringBuilder.append("'").append(equipmentSlotString).append("'").append(" : ").append("'").append(nbtString).append("',");
                continue;
            }
            gearStringBuilder.append("'").append(equipmentSlotString).append("'").append(" : ").append("'',");
        }
        Inventory playerInventory = player.m_150109_();
        for (int i = 0; i < 36; ++i) {
            ItemStack slotStack = playerInventory.m_8020_(i);
            if (!slotStack.m_41619_()) {
                String nbtString = GearFunctions.getFormattedNBTStringFromItemStack(slotStack);
                gearStringBuilder.append("\n").append(i).append(" : ").append("'").append(nbtString).append("',");
                continue;
            }
            gearStringBuilder.append("\n").append(i).append(" : '',");
        }
        if (parseActiveEffects) {
            StringBuilder effectsStringBuilder = new StringBuilder();
            Map activeEffectsMap = player.m_21221_();
            if (activeEffectsMap.size() > 0) {
                Registry mobEffectRegistry = player.f_19853_.m_5962_().m_175515_(Registry.f_122900_);
                ArrayList<String> effectResourceLocationList = new ArrayList<String>();
                HashMap<String, CallSite> effectLineData = new HashMap<String, CallSite>();
                for (MobEffect mobEffect : activeEffectsMap.keySet()) {
                    MobEffectInstance mobEffectInstance = (MobEffectInstance)activeEffectsMap.get(mobEffect);
                    ResourceLocation resourceLocation = mobEffectRegistry.m_7981_((Object)mobEffect);
                    if (resourceLocation == null) continue;
                    String rlString = resourceLocation.toString();
                    int level = mobEffectInstance.m_19564_() + 1;
                    int duration = mobEffectInstance.m_19557_();
                    effectResourceLocationList.add(rlString);
                    effectLineData.put(rlString, (CallSite)((Object)(rlString + ";lvl:" + level + ";duration:" + duration)));
                }
                Collections.sort(effectResourceLocationList);
                for (String rlString : effectResourceLocationList) {
                    String lineData = (String)effectLineData.get(rlString);
                    if (!effectsStringBuilder.toString().equals("")) {
                        effectsStringBuilder.append("|");
                    }
                    effectsStringBuilder.append(lineData);
                }
            }
            gearStringBuilder.append("\n'effects' : '").append((CharSequence)effectsStringBuilder).append("',");
        }
        return gearStringBuilder.toString();
    }

    public static String getPlayerGearStringFromHashMap(HashMap<String, ItemStack> gearStringHashMap) {
        StringBuilder gearStringBuilder = new StringBuilder();
        for (EquipmentSlot equipmentSlot : Constants.equipmentSlots) {
            if (!gearStringBuilder.isEmpty()) {
                gearStringBuilder.append("\n");
            }
            String equipmentSlotString = equipmentSlot.m_20751_();
            String nbtString = "";
            if (gearStringHashMap.containsKey(equipmentSlotString)) {
                nbtString = GearFunctions.getFormattedNBTStringFromItemStack(gearStringHashMap.get(equipmentSlotString));
            }
            gearStringBuilder.append("'").append(equipmentSlotString).append("'").append(" : ").append("'").append(nbtString).append("',");
        }
        NonNullList emptyInventoryList = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
        for (int i = 0; i < emptyInventoryList.size(); ++i) {
            String nbtString = "";
            if (gearStringHashMap.containsKey("" + i)) {
                nbtString = GearFunctions.getFormattedNBTStringFromItemStack(gearStringHashMap.get("" + i));
            }
            gearStringBuilder.append("\n").append(i).append(" : '").append(nbtString).append("',");
        }
        return gearStringBuilder.toString();
    }

    public static HashMap<String, ItemStack> getHashMapFromGearString(String gearString) {
        HashMap<String, ItemStack> gearHashMap = new HashMap<String, ItemStack>();
        for (String line : GearFunctions.getGearStringSplit(gearString)) {
            String slotString = GearFunctions.getSlotStringFromLine(line);
            ItemStack itemStack = GearFunctions.getItemStackFromGearStringLine(line);
            if (itemStack == null) {
                itemStack = ItemStack.f_41583_.m_41777_();
            }
            gearHashMap.put(slotString, itemStack);
        }
        return gearHashMap;
    }

    public static List<ItemStack> getItemStackListFromGearString(String gearString) {
        ArrayList<ItemStack> gearList = new ArrayList<ItemStack>();
        for (String line : GearFunctions.getGearStringSplit(gearString)) {
            ItemStack itemStack = GearFunctions.getItemStackFromGearStringLine(line);
            if (itemStack == null) continue;
            gearList.add(itemStack);
        }
        return gearList;
    }

    public static List<MobEffectInstance> getEffectsFromGearString(Player player, String gearString) {
        return GearFunctions.getEffectsFromGearString(player.f_19853_, gearString);
    }

    public static List<MobEffectInstance> getEffectsFromGearString(Level level, String gearString) {
        return GearFunctions.getEffectsFromGearString((Registry<MobEffect>)level.m_5962_().m_175515_(Registry.f_122900_), gearString);
    }

    public static List<MobEffectInstance> getEffectsFromGearString(Registry<MobEffect> mobEffectRegistry, String gearString) {
        for (String line : GearFunctions.getGearStringSplit(gearString)) {
            String slotString = GearFunctions.getSlotStringFromLine(line);
            if (!slotString.equalsIgnoreCase("effects")) continue;
            return GearFunctions.getEffectsFromLine(mobEffectRegistry, line);
        }
        return new ArrayList<MobEffectInstance>();
    }

    public static boolean areTwoGearStringsEqual(String gearStringOne, String gearStringTwo) {
        List<ItemStack> itemStackListOne = GearFunctions.getItemStackListFromGearString(gearStringOne);
        List<ItemStack> itemStackListTwo = GearFunctions.getItemStackListFromGearString(gearStringTwo);
        for (ItemStack itemStackOne : itemStackListOne) {
            Item itemOne = itemStackOne.m_41720_();
            boolean foundMatch = false;
            for (ItemStack itemStackTwo : itemStackListTwo) {
                Item itemTwo = itemStackTwo.m_41720_();
                if (!itemOne.equals(itemTwo) || itemStackOne.m_41613_() != itemStackTwo.m_41613_()) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    public static String sortGearString(String gearString) {
        String data;
        String slotString;
        StringBuilder sortedGearString = new StringBuilder();
        HashMap<String, String> gearHashMap = new HashMap<String, String>();
        for (String string : GearFunctions.getGearStringSplit(gearString)) {
            slotString = GearFunctions.getSlotStringFromLine(string);
            data = GearFunctions.getDataFromLine(string);
            gearHashMap.put(slotString, data);
        }
        for (EquipmentSlot equipmentSlot : Constants.equipmentSlots) {
            String equipmentSlotName = equipmentSlot.m_20751_();
            if (!gearHashMap.containsKey(equipmentSlotName)) continue;
            sortedGearString.append("'").append(equipmentSlotName).append("' : '").append((String)gearHashMap.get(equipmentSlotName)).append("',").append(System.lineSeparator());
        }
        for (String string : GearFunctions.getGearStringSplit(gearString)) {
            slotString = GearFunctions.getSlotStringFromLine(string);
            data = GearFunctions.getDataFromLine(string);
            if (!NumberFunctions.isNumeric(slotString)) continue;
            sortedGearString.append("'").append(slotString).append("' : '").append(data).append("',").append(System.lineSeparator());
        }
        if (gearHashMap.containsKey("effects")) {
            sortedGearString.append("'effects' : '").append((String)gearHashMap.get("effects")).append("',").append(System.lineSeparator());
        }
        return sortedGearString.toString().strip();
    }

    private static ItemStack getItemStackFromGearStringLine(String line) {
        ItemStack itemStack = ItemStack.f_41583_;
        String[] stringArray = GearFunctions.getStringArrayFromLine(line);
        if (stringArray.length != 2) {
            return null;
        }
        String data = GearFunctions.getDataFromStringArray(stringArray);
        try {
            CompoundTag compoundTag = GearFunctions.parseFormattedTag(data);
            itemStack = ItemStack.m_41712_((CompoundTag)compoundTag);
        }
        catch (CommandSyntaxException ex0) {
            try {
                data = GearFunctions.extendedFormatDataString(data);
                CompoundTag compoundTag = GearFunctions.parseFormattedTag(data);
                itemStack = ItemStack.m_41712_((CompoundTag)compoundTag);
            }
            catch (CommandSyntaxException ex1) {
                return null;
            }
        }
        return itemStack.m_41777_();
    }

    private static List<MobEffectInstance> getEffectsFromLine(Player player, String line) {
        return GearFunctions.getEffectsFromLine(player.f_19853_, line);
    }

    private static List<MobEffectInstance> getEffectsFromLine(Level level, String line) {
        return GearFunctions.getEffectsFromLine((Registry<MobEffect>)level.m_5962_().m_175515_(Registry.f_122900_), line);
    }

    private static List<MobEffectInstance> getEffectsFromLine(Registry<MobEffect> mobEffectRegistry, String line) {
        ArrayList<MobEffectInstance> mobEffectInstanceList = new ArrayList<MobEffectInstance>();
        String effectData = GearFunctions.getDataFromLine(line);
        for (String effectRaw : effectData.split("\\|")) {
            int lvl;
            String[] effectSpl = effectRaw.split(";");
            if (effectSpl.length != 3) continue;
            String rlString = effectSpl[0];
            String lvlRaw = effectSpl[1];
            String durationRaw = effectSpl[2];
            if (!lvlRaw.contains(":") || !durationRaw.contains(":")) continue;
            String lvlString = lvlRaw.split(":")[1].strip();
            String durationString = durationRaw.split(":")[1].strip();
            if (!NumberFunctions.isNumeric(lvlString) || !NumberFunctions.isNumeric(durationString) || (lvl = Integer.parseInt(lvlString)) == 0) continue;
            int duration = Integer.parseInt(durationString);
            MobEffect mobEffect = (MobEffect)mobEffectRegistry.m_7745_(new ResourceLocation(rlString));
            if (mobEffect == null) continue;
            MobEffectInstance mobEffectInstance = new MobEffectInstance(mobEffect, duration, lvl - 1);
            mobEffectInstanceList.add(mobEffectInstance);
        }
        return mobEffectInstanceList;
    }

    private static String[] getGearStringSplit(String gearString) {
        return gearString.split("',[\\r\\n]+");
    }

    private static String getSlotStringFromLine(String line) {
        return GearFunctions.getStringArrayFromLine(line)[0].replace("'", "").strip();
    }

    private static String getDataFromStringArray(String[] stringArray) {
        if (stringArray.length < 2) {
            return "";
        }
        String rawData = stringArray[1];
        if (rawData.startsWith("'")) {
            rawData = rawData.substring(1);
        }
        if (rawData.endsWith("'")) {
            rawData = rawData.substring(0, rawData.length() - 1);
        }
        return rawData.replaceAll("\r", "");
    }

    private static String[] getStringArrayFromLine(String line) {
        if (((String)(line = ((String)line).trim())).endsWith(",")) {
            line = ((String)line).substring(0, ((String)line).length() - 1);
        }
        if (!((String)line).endsWith("'")) {
            line = (String)line + "'";
        }
        return ((String)line).split(" : ", 2);
    }

    private static String getDataFromLine(String line) {
        return GearFunctions.getDataFromStringArray(GearFunctions.getStringArrayFromLine(line));
    }

    private static EquipmentSlot getEquipmentSlotFromSlotString(String slotString) {
        for (EquipmentSlot equipmentSlot : Constants.equipmentSlots) {
            if (!equipmentSlot.m_20751_().equalsIgnoreCase(slotString.strip())) continue;
            return equipmentSlot;
        }
        return null;
    }

    private static String getFormattedNBTStringFromItemStack(ItemStack itemStack) {
        String nbtString = ItemFunctions.getNBTStringFromItemStack(itemStack);
        nbtString = nbtString.replaceAll("[\\r\\n]", "|n").replace("'", "\u2035");
        return nbtString;
    }

    private static CompoundTag parseFormattedTag(String data) throws CommandSyntaxException {
        data = data.replace("|n", "\n").replace("\u2035", "'");
        return TagParser.m_129359_((String)data);
    }

    private static String extendedFormatDataString(String rawData) {
        return rawData.replace("\",\"", "|||,|||").replace(" \"", " '").replace("\" ", "' ").replace("|||,|||", "\",\"");
    }
}

