/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_fabric.processing;

import com.natamus.collective_common_fabric.services.Services;
import com.natamus.treeharvester_common_fabric.data.Constants;
import com.natamus.treeharvester_common_fabric.data.Variables;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class AxeBlacklist {
    public static void attemptProcessingAxeBlacklist(class_1937 level) {
        if (!Variables.processedAxeBlacklist) {
            try {
                AxeBlacklist.setupAxeBlacklist(level);
                Variables.processedAxeBlacklist = true;
            }
            catch (IOException ex) {
                System.out.println("[Tree Harvester] Something went wrong setting up the axe blacklist file.");
            }
        }
    }

    public static void setupAxeBlacklist(class_1937 level) throws IOException {
        class_2378 itemRegistry = level.method_30349().method_30530(class_2378.field_25108);
        ArrayList<String> blacklist = new ArrayList<String>();
        PrintWriter writer = null;
        if (!Constants.dir.isDirectory() || !Constants.file.isFile()) {
            boolean ignored = Constants.dir.mkdirs();
            writer = new PrintWriter(Constants.dirpath + File.separator + "harvestable_axe_blacklist.txt", StandardCharsets.UTF_8);
        } else {
            String blcontent = new String(Files.readAllBytes(Paths.get(Constants.dirpath + File.separator + "harvestable_axe_blacklist.txt", new String[0])));
            for (String axerl : blcontent.split(",")) {
                String name = axerl.replace("\n", "").trim();
                if (name.startsWith("//") || !name.startsWith("!")) continue;
                blacklist.add(name.replace("!", ""));
            }
        }
        if (writer != null) {
            writer.println("// To disable a certain axe from being able to harvest trees, add an exclamation mark (!) in front of the line,");
        }
        for (class_1792 item : itemRegistry) {
            class_2960 rl;
            if (!Services.TOOLFUNCTIONS.isAxe(new class_1799((class_1935)item)) || (rl = itemRegistry.method_10221((Object)item)) == null) continue;
            String name = rl.toString();
            if (writer != null) {
                writer.println(name + ",");
            }
            if (blacklist.contains(name)) continue;
            Variables.allowedAxes.add(item);
        }
        if (writer != null) {
            writer.close();
        }
    }
}

