/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.mixin;

import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends Level {
    @Unique
    ResourceLocation END_DIMENSION = new ResourceLocation("minecraft", "the_end");

    @Shadow
    @Nullable
    public abstract EndDragonFight m_8586_();

    protected ServerLevelMixin(WritableLevelData $$0, ResourceKey<Level> $$1, Holder<DimensionType> $$2, Supplier<ProfilerFiller> $$3, boolean $$4, boolean $$5, long $$6, int $$7) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void betterendisland_tickInitialDragonSummonTrigger(BooleanSupplier booleanSupplier, CallbackInfo ci) {
        this.betterendisland$tickSummonDragonFight();
        this.betterendisland$tickBellSound();
    }

    @Unique
    private void betterendisland$tickBellSound() {
        if (this.m_46472_().m_135782_().equals((Object)this.END_DIMENSION) && this.m_8586_() != null) {
            ((IDragonFight)this.m_8586_()).betterendisland$tickBellSound();
        }
    }

    @Unique
    private void betterendisland$tickSummonDragonFight() {
        if (this.m_46472_().m_135782_().equals((Object)this.END_DIMENSION) && this.m_8586_() != null && !((IDragonFight)this.m_8586_()).betterendisland$hasDragonEverSpawned() && ((IDragonFight)this.m_8586_()).betterendisland$getDragonRespawnStage() == null && this.f_46442_.m_6793_() % 5L == 0L) {
            double minDistance = -1.0;
            double requiredDistance = 25.0;
            Player foundPlayer = null;
            for (Player player : this.m_6907_()) {
                double distance;
                if (!EntitySelector.f_20408_.test(player) || !((distance = this.xzDistanceSqr(0.0, 0.0, player.m_20182_().m_7096_(), player.m_20182_().m_7094_())) < requiredDistance * requiredDistance) || minDistance != -1.0 && !(distance < minDistance)) continue;
                minDistance = distance;
                foundPlayer = player;
            }
            if (foundPlayer != null) {
                ((IDragonFight)this.m_8586_()).betterendisland$initialRespawn();
            }
        }
    }

    @Unique
    private double xzDistanceSqr(double x1, double z1, double x2, double z2) {
        double xDist = x2 - x1;
        double zDist = z2 - z1;
        return xDist * xDist + zDist * zDist;
    }
}

